/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PodGenerationNode
implements NodeInspector {
    private final Pod pod;
    private final PodPlacer podPlacer;
    @Nullable
    private final Float seasonValue;
    private final int blocksPerPlacedPod;
    private final BlockPos rootPos;
    private final int lowestTrunkHeight;
    private boolean finished = false;

    public PodGenerationNode(Pod pod, PodPlacer podPlacer, @Nullable Float seasonValue, int blocksPerPlacedPods, BlockPos rootPos, int lowestTrunkHeight) {
        this.podPlacer = podPlacer;
        this.seasonValue = seasonValue;
        this.blocksPerPlacedPod = blocksPerPlacedPods;
        this.pod = pod;
        this.rootPos = rootPos;
        this.lowestTrunkHeight = lowestTrunkHeight;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        if (!this.finished) {
            int radius;
            if (pos.getY() - this.rootPos.above().getY() < this.lowestTrunkHeight) {
                return false;
            }
            BranchBlock branch = TreeHelper.getBranch(state);
            if (branch != null && this.pod.isValidRadius(radius = branch.getRadius(state))) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos deltaPos;
                    int hashCode = CoordUtils.coordHashCode(pos.offset(dir.getNormal()), 1);
                    if (hashCode % 97 % this.blocksPerPlacedPod != 0 || !level.isEmptyBlock(deltaPos = pos.relative(dir)) && !(level.getBlockState(deltaPos).getBlock() instanceof TrunkShellBlock)) continue;
                    if (!dir.getAxis().isHorizontal()) {
                        dir = Direction.NORTH;
                    }
                    this.podPlacer.place(level, deltaPos, this.seasonValue, dir.getOpposite(), radius);
                    this.finished = true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public static interface PodPlacer {
        public void place(LevelAccessor var1, BlockPos var2, @Nullable Float var3, Direction var4, int var5);
    }
}

