/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import com.dtteam.dynamictrees.api.season.SeasonType;
import com.dtteam.dynamictrees.platform.Services;
import net.minecraft.util.Mth;

public class ActiveSeasonGrowthCalculator
implements SeasonGrowthCalculator {
    protected float clippedSineWave(float seasonValue, float qPhase, float amplitude, float bias) {
        return Mth.clamp((float)((float)Math.sin((double)(seasonValue / 2.0f) * Math.PI + 1.5707963267948966 * (double)qPhase) * amplitude + bias), (float)0.0f, (float)1.0f);
    }

    private float peakClimateOffset(SeasonType type) {
        float summerOffset = -0.5f;
        float wetSeasonOffset = (float)((double)summerOffset + Services.CONFIG.getDoubleConfig("wetSeasonOffset"));
        if (type == SeasonType.DRY_WET) {
            return wetSeasonOffset;
        }
        return summerOffset;
    }

    @Override
    public float calcGrowthRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 1.0f, 1.0f);
            case ClimateZoneType.TROPICAL -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 0.3f, 0.9f);
            case ClimateZoneType.ARID -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 1.0f, 0.0f);
            case ClimateZoneType.COLD -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 2.0f, 0.0f);
            default -> 1.0f;
        };
    }

    @Override
    public float calcSeedDropRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 1.0f, 0.3f);
            case ClimateZoneType.TROPICAL -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 0.3f, 0.9f);
            case ClimateZoneType.ARID -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 5.0f, -0.35f);
            case ClimateZoneType.COLD -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 0.6f, 0.4f);
            default -> 1.0f;
        };
    }

    @Override
    public float calcFruitProductionRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 1.0f, 1.0f);
            case ClimateZoneType.TROPICAL -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 0.3f, 0.9f);
            case ClimateZoneType.ARID -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.DRY_WET), 1.0f, 0.7f);
            case ClimateZoneType.COLD -> this.clippedSineWave(seasonValue.floatValue(), this.peakClimateOffset(SeasonType.TEMPERATURE), 2.0f, 0.0f);
            default -> 1.0f;
        };
    }

    @Override
    public Float getPeakFruitProductionSeasonValue(ClimateZoneType type) {
        return switch (type) {
            case ClimateZoneType.TEMPERATE, ClimateZoneType.COLD -> Float.valueOf(2.0f + this.peakClimateOffset(SeasonType.TEMPERATURE));
            case ClimateZoneType.TROPICAL, ClimateZoneType.ARID -> Float.valueOf(2.0f + this.peakClimateOffset(SeasonType.DRY_WET));
            default -> null;
        };
    }
}

