/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;

public class ClimateHelper {
    private static final double[][] CLIMATE_MULTIPLIER_TABLE = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 0.6, 0.9, 0.4}, {1.0, 0.7, 1.0, 0.6, 0.1}, {1.0, 0.6, 0.7, 1.0, 0.3}, {1.0, 0.9, 0.4, 0.8, 1.0}};

    public static double climateMultiplier(Species species, ClimateZoneType plantedIn, double minimum) {
        ClimateZoneType preferred = species.getPreferredClimate();
        double realValue = CLIMATE_MULTIPLIER_TABLE[preferred.ordinal()][plantedIn.ordinal()];
        return realValue * (1.0 - minimum) + minimum;
    }

    public static ClimateZoneType getClimate(LevelAccessor level, BlockPos rootPos) {
        return SeasonCompatibilityHandler.getSeasonManager().getClimate(level, rootPos);
    }
}

