/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import com.dtteam.dynamictrees.api.season.SeasonManager;
import com.dtteam.dynamictrees.api.season.SeasonProvider;
import com.dtteam.dynamictrees.systems.season.NullSeasonGrowthCalculator;
import com.dtteam.dynamictrees.systems.season.NullSeasonProvider;
import com.dtteam.dynamictrees.systems.season.SeasonContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class NormalSeasonManager
implements SeasonManager {
    public static final Supplier<SeasonManager> NULL = NormalSeasonManager::new;
    private final Map<ResourceLocation, SeasonContext> seasonContextMap = new HashMap<ResourceLocation, SeasonContext>();
    private Function<Level, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper = w -> new Tuple((Object)new NullSeasonProvider(), (Object)new NullSeasonGrowthCalculator());
    private static final float ARID_THRESHHOLD = 1.0f;
    private static final float ARID_DOWNFALL_THRESHHOLD = 0.0f;
    private static final float TROPICAL_THRESHHOLD = 0.8f;
    private static final float COLD_THRESHHOLD = 0.2f;
    private BiPredicate<LevelAccessor, BlockPos> isTropical = (level, rootPos) -> NormalSeasonManager.getBiomeForDist(level, rootPos).getBaseTemperature() > 0.8f;
    private BiPredicate<LevelAccessor, BlockPos> isCold = (level, rootPos) -> NormalSeasonManager.getBiomeForDist(level, rootPos).getBaseTemperature() < 0.2f;
    private BiPredicate<LevelAccessor, BlockPos> isArid = (level, rootPos) -> {
        Biome b = NormalSeasonManager.getBiomeForDist(level, rootPos);
        return b.getBaseTemperature() >= 1.0f;
    };

    public NormalSeasonManager() {
    }

    public NormalSeasonManager(Function<Level, Tuple<SeasonProvider, SeasonGrowthCalculator>> seasonMapper) {
        this.seasonMapper = seasonMapper;
    }

    private Tuple<SeasonProvider, SeasonGrowthCalculator> createProvider(Level level) {
        return this.seasonMapper.apply(level);
    }

    private SeasonContext getContext(Level level) {
        return this.seasonContextMap.computeIfAbsent(level.dimension().location(), d -> {
            Tuple<SeasonProvider, SeasonGrowthCalculator> tuple = this.createProvider(level);
            return new SeasonContext((SeasonProvider)tuple.getA(), (SeasonGrowthCalculator)tuple.getB());
        });
    }

    @Override
    public void flushMappings() {
        this.seasonContextMap.clear();
    }

    private static Biome getBiomeForDist(LevelAccessor level, BlockPos pos) {
        if (level instanceof Level) {
            return (Biome)level.getBiome(pos).value();
        }
        return (Biome)level.getUncachedNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2).value();
    }

    public void setTropicalPredicate(BiPredicate<LevelAccessor, BlockPos> predicate) {
        this.isTropical = predicate;
    }

    public void setAridPredicate(BiPredicate<LevelAccessor, BlockPos> predicate) {
        this.isArid = predicate;
    }

    public void setColdPredicate(BiPredicate<LevelAccessor, BlockPos> predicate) {
        this.isCold = predicate;
    }

    @Override
    public ClimateZoneType getClimate(LevelAccessor level, BlockPos rootPos) {
        if (this.isCold.test(level, rootPos)) {
            return ClimateZoneType.COLD;
        }
        if (this.isArid.test(level, rootPos)) {
            return ClimateZoneType.ARID;
        }
        if (this.isTropical.test(level, rootPos)) {
            return ClimateZoneType.TROPICAL;
        }
        return ClimateZoneType.TEMPERATE;
    }

    @Override
    public void updateTick(Level level, long dayTime) {
        this.getContext(level).updateTick(level, dayTime);
    }

    @Override
    public float getGrowthFactor(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        ClimateZoneType climate = this.getClimate((LevelAccessor)level, rootPos);
        return context.getGrowthFactor(offset, climate);
    }

    @Override
    public float getSeedDropFactor(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        ClimateZoneType climate = this.getClimate((LevelAccessor)level, rootPos);
        return context.getSeedDropFactor(offset, climate);
    }

    @Override
    public float getFruitProductionFactor(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        ClimateZoneType climate = this.getClimate((LevelAccessor)level, rootPos);
        return context.getFruitProductionFactor(offset, climate);
    }

    @Override
    public Float getSeasonValue(Level level, BlockPos pos) {
        return this.getContext(level).getSeasonProvider().getSeasonValue(level, pos);
    }

    @Override
    public Float getPeakFruitProductionSeasonValue(Level level, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(level);
        ClimateZoneType climate = this.getClimate((LevelAccessor)level, rootPos);
        return context.getPeakFruitProductionSeasonValue(offset, climate);
    }

    @Override
    public boolean shouldSnowMelt(Level level, BlockPos pos) {
        return this.getContext(level).getSeasonProvider().shouldSnowMelt(level, pos);
    }

    @Override
    public void clearCache(Level level) {
        this.getContext(level).clearCache();
    }
}

