/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import com.dtteam.dynamictrees.api.season.SeasonProvider;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class SeasonContext {
    private final SeasonProvider provider;
    private final SeasonGrowthCalculator calculator;
    private final HashMap<ClimateZoneType, HashMap<Integer, Float>> cachedGrowthFactors = new HashMap();
    private final HashMap<ClimateZoneType, HashMap<Integer, Float>> cachedSeedDropFactors = new HashMap();
    private final HashMap<ClimateZoneType, HashMap<Integer, Float>> cachedFruitProductionFactors = new HashMap();
    private Float seasonValue;
    private final HashMap<ClimateZoneType, Float> peakFruitSeasons = new HashMap();
    private long methodTicks = 0L;
    private static final int updateRate = 20;
    private static final float seasonValueCacheMultiplier = 256.0f;

    public SeasonContext(SeasonProvider provider, SeasonGrowthCalculator calculator) {
        this.provider = provider;
        this.calculator = calculator;
        for (ClimateZoneType climate : ClimateZoneType.values()) {
            this.peakFruitSeasons.put(climate, calculator.getPeakFruitProductionSeasonValue(climate));
        }
    }

    public void updateTick(Level world, long dayTime) {
        if (this.methodTicks % 20L == 0L) {
            this.provider.updateTick(world, dayTime);
            this.seasonValue = this.provider.getSeasonValue(world, BlockPos.ZERO);
        }
        ++this.methodTicks;
    }

    public SeasonProvider getSeasonProvider() {
        return this.provider;
    }

    public SeasonGrowthCalculator getCalculator() {
        return this.calculator;
    }

    public float getGrowthFactor(float offset, ClimateZoneType climate) {
        if (this.seasonValue == null || climate == ClimateZoneType.NONE) {
            return 1.0f;
        }
        float season = (this.seasonValue.floatValue() + offset) % 4.0f;
        int key = (int)(season * 256.0f);
        HashMap values = this.cachedGrowthFactors.computeIfAbsent(climate, k -> new HashMap());
        if (!values.containsKey(key)) {
            float calculated = this.calculator.calcGrowthRate(Float.valueOf(season), climate);
            values.put(key, Float.valueOf(calculated));
        }
        return ((Float)values.get(key)).floatValue();
    }

    public float getSeedDropFactor(float offset, ClimateZoneType climate) {
        if (this.seasonValue == null || climate == ClimateZoneType.NONE) {
            return 1.0f;
        }
        float season = (this.seasonValue.floatValue() + offset) % 4.0f;
        int key = (int)(season * 256.0f);
        HashMap values = this.cachedSeedDropFactors.computeIfAbsent(climate, k -> new HashMap());
        if (!values.containsKey(key)) {
            float calculated = this.calculator.calcSeedDropRate(Float.valueOf(season), climate);
            values.put(key, Float.valueOf(calculated));
        }
        return ((Float)values.get(key)).floatValue();
    }

    public float getFruitProductionFactor(float offset, ClimateZoneType climate) {
        if (this.seasonValue == null || climate == ClimateZoneType.NONE) {
            return 1.0f;
        }
        float season = (this.seasonValue.floatValue() + offset) % 4.0f;
        int key = (int)(season * 256.0f);
        HashMap values = this.cachedFruitProductionFactors.computeIfAbsent(climate, k -> new HashMap());
        if (!values.containsKey(key)) {
            float calculated = this.calculator.calcFruitProductionRate(Float.valueOf(season), climate);
            values.put(key, Float.valueOf(calculated));
        }
        return ((Float)values.get(key)).floatValue();
    }

    public Float getPeakFruitProductionSeasonValue(float offset, ClimateZoneType climate) {
        if (this.seasonValue == null || climate == ClimateZoneType.NONE) {
            return null;
        }
        return Float.valueOf((this.peakFruitSeasons.get((Object)climate).floatValue() + offset) % 4.0f);
    }

    public void clearCache() {
        this.cachedGrowthFactors.clear();
        this.cachedSeedDropFactors.clear();
        this.cachedFruitProductionFactors.clear();
        this.peakFruitSeasons.clear();
    }
}

