/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.SeasonCompatibilityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class SeasonHelper {
    public static final float SPRING_START = 0.0f;
    public static final float SPRING_MIDDLE = 0.5f;
    public static final float SUMMER_START = 1.0f;
    public static final float SUMMER_MIDDLE = 1.5f;
    public static final float AUTUMN_START = 2.0f;
    public static final float AUTUMN_MIDDLE = 2.5f;
    public static final float WINTER_START = 3.0f;
    public static final float WINTER_MIDDLE = 3.5f;

    public static void updateTick(Level level, long dayTime) {
        SeasonCompatibilityHandler.getSeasonManager().updateTick(level, dayTime);
    }

    public static float globalSeasonalGrowthFactor(LevelContext levelContext, BlockPos rootPos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalGrowthFactor") != false ? SeasonCompatibilityHandler.getSeasonManager().getGrowthFactor(levelContext.level(), rootPos, offset) : 1.0f;
    }

    public static float globalSeasonalSeedDropFactor(LevelContext levelContext, BlockPos pos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalSeedDropFactor") != false ? SeasonCompatibilityHandler.getSeasonManager().getSeedDropFactor(levelContext.level(), pos, offset) : 1.0f;
    }

    public static float globalSeasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalFruitProductionFactor") != false ? SeasonCompatibilityHandler.getSeasonManager().getFruitProductionFactor(levelContext.level(), pos, offset) : 1.0f;
    }

    public static Float getPeakFruitProductionSeason(LevelContext levelContext, BlockPos pos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalFruitProductionFactor") != false ? SeasonCompatibilityHandler.getSeasonManager().getPeakFruitProductionSeasonValue(levelContext.level(), pos, offset) : null;
    }

    public static Float getSeasonValue(LevelContext levelContext, BlockPos pos) {
        return SeasonCompatibilityHandler.getSeasonManager().getSeasonValue(levelContext.level(), pos);
    }

    public static boolean isSeasonBetween(Float testValue, float SeasonA, float SeasonB) {
        testValue = Float.valueOf(testValue.floatValue() % 4.0f);
        if ((SeasonA %= 4.0f) <= (SeasonB %= 4.0f)) {
            return testValue.floatValue() > SeasonA && testValue.floatValue() < SeasonB;
        }
        return testValue.floatValue() < SeasonB || testValue.floatValue() > SeasonA;
    }

    public static boolean shouldSnowMelt(Level level, BlockPos pos) {
        return SeasonCompatibilityHandler.getSeasonManager().shouldSnowMelt(level, pos);
    }
}

