/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree;

import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.block.pod.PodBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.systems.nodemapper.CollectorNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ChunkTreeHelper {
    private static final int CHUNK_WIDTH = 16;
    private static final byte NONE = 0;
    private static final byte TREE = 1;
    private static final byte SURR = 2;

    public static int removeOrphanedBranchNodes(Level level, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        HashSet<BlockPos> found = new HashSet<BlockPos>();
        BlockPosBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(level, chunkPos, radius);
        int orphansCleared = 0;
        for (BlockPos pos : bounds) {
            Direction trunkDir;
            BlockPos trunkPos;
            BlockState trunkState;
            Optional<BranchBlock> trunk;
            BlockState state = level.getBlockState(pos);
            Optional<BranchBlock> branchBlock = TreeHelper.getBranchOpt(state);
            if (branchBlock.isEmpty()) continue;
            BlockPos rootPos = TreeHelper.findRootNode(level, pos);
            if (rootPos == BlockPos.ZERO) {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            BlockState rootyState = level.getBlockState(rootPos);
            Optional<SoilBlock> rootyBlock = TreeHelper.getRootyOpt(rootyState);
            if (rootyBlock.isEmpty() || (trunk = TreeHelper.getBranchOpt(trunkState = level.getBlockState(trunkPos = rootPos.relative(trunkDir = rootyBlock.get().getTrunkDirection((BlockGetter)level, rootPos))))).isEmpty()) continue;
            MapSignal signal = new MapSignal();
            signal.destroyLoopedNodes = false;
            trunk.get().analyse(trunkState, (LevelAccessor)level, trunkPos, null, signal);
            if (signal.multiroot || signal.overflow) {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            trunk.get().analyse(trunkState, (LevelAccessor)level, trunkPos, null, new MapSignal(new CollectorNode(found)));
        }
        return orphansCleared;
    }

    public static int removeAllBranchesFromChunk(Level level, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        BlockPosBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(level, chunkPos, radius);
        AtomicInteger treesCleared = new AtomicInteger();
        for (BlockPos pos : bounds) {
            BlockState state = level.getBlockState(pos);
            TreeHelper.getBranchOpt(state).ifPresent(branchBlock -> {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock, pos);
                treesCleared.getAndIncrement();
            });
        }
        return treesCleared.get();
    }

    public static BlockPosBounds getEffectiveBlockBounds(Level level, ChunkPos chunkPos, int radius) {
        LevelChunk chunk = level.getChunk(chunkPos.x, chunkPos.z);
        BlockPosBounds bounds = new BlockPosBounds((LevelAccessor)level, chunkPos);
        bounds.shrink(Direction.UP, level.getHeight() - 1 - (ChunkTreeHelper.getTopFilledSegment(chunk) + 16));
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            bounds.expand(dir, radius * 16);
        }
        return bounds;
    }

    private static int getTopFilledSegment(LevelChunk chunk) {
        return chunk.getHighestSectionPosition();
    }

    private static void doTreeDestroy(Level level, BranchBlock branchBlock, BlockPos pos) {
        BranchDestructionData destroyData = branchBlock.destroyBranchFromNode(level, pos, Direction.DOWN, true, null);
        destroyData.leavesDrops.clear();
        FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        ChunkTreeHelper.cleanupNeighbors(level, destroyData);
    }

    public static void cleanupNeighbors(Level level, BranchDestructionData destroyData) {
        if (level.isClientSide) {
            return;
        }
        BlockPosBounds treeBounds = new BlockPosBounds(destroyData.cutPos);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(treeBounds::union);
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(treeBounds::union);
        treeBounds.expand(1);
        SimpleVoxmap treeVoxmap = new SimpleVoxmap(treeBounds);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        SimpleVoxmap outlineVoxmap = new SimpleVoxmap(treeVoxmap);
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> {
            for (Direction dir : Direction.values()) {
                outlineVoxmap.setVoxel((BlockPos)pos.move(dir.getNormal()), (byte)2);
            }
        });
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> outlineVoxmap.setVoxel((BlockPos)pos, (byte)0));
        outlineVoxmap.getAllNonZero((byte)2).forEach(pos -> ChunkTreeHelper.cleanupBlock(level, (BlockPos)pos));
    }

    public static void cleanupBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() == Blocks.AIR) {
            return;
        }
        Block block = state.getBlock();
        if (block instanceof SnowLayerBlock || block instanceof FruitBlock || block instanceof PodBlock || block instanceof SurfaceRootBlock) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        } else if (block instanceof VineBlock) {
            ChunkTreeHelper.cleanupVines(level, pos);
        }
    }

    public static void cleanupVines(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mblock = pos.mutable();
        while (level.getBlockState((BlockPos)mblock).getBlock() instanceof VineBlock) {
            level.setBlock((BlockPos)mblock, Blocks.AIR.defaultBlockState(), 2);
            mblock.move(Direction.DOWN);
        }
    }

    public static boolean canCheckSurroundings(LevelAccessor accessor, AABB bounds) {
        return accessor.getBlockStatesIfLoaded(bounds).findAny().isPresent();
    }

    public static boolean canCheckSurroundings(LevelAccessor accessor, BlockPos pos, int r) {
        return ChunkTreeHelper.canCheckSurroundings(accessor, AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-r, -r, -r), (BlockPos)pos.offset(r, r, r)));
    }

    public static boolean isSurroundedByLoadedChunks(Level level, BlockPos pos) {
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            Vec3i dir = surr.getOffset();
            if (((ServerLevel)level).isPositionEntityTicking(pos.offset(dir))) continue;
            return false;
        }
        return true;
    }

    public static boolean canAccessStateSafely(BlockGetter level, BlockPos pos) {
        if (level instanceof LevelReader) {
            return ((LevelReader)level).hasChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        }
        if (level instanceof PathNavigationRegion) {
            PathNavigationRegion pathLevel = (PathNavigationRegion)level;
            return !(pathLevel.getChunk(pos) instanceof EmptyLevelChunk);
        }
        return true;
    }

    @Nullable
    public static BlockState getStateSafe(BlockGetter level, BlockPos blockPos) {
        return ChunkTreeHelper.canAccessStateSafely(level, blockPos) ? level.getBlockState(blockPos) : null;
    }
}

