/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.utility;

import com.dtteam.dynamictrees.tree.species.Species;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class CoordUtils {
    public static int coordXor = 0;
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
    private static final int[][] coordHashMap = new int[][]{{4111, 271, 3067}, {7933711, 6144389, 9538033}, {9973, 8287, 9721}, {7211, 5437, 9613}};

    public static Direction getRandomDir(RandomSource rand) {
        return Direction.values()[2 + rand.nextInt(4)];
    }

    public static BlockPos getRayTraceFruitPos(LevelAccessor level, Species species, BlockPos treePos, BlockPos branchPos, boolean worldGen) {
        BlockPos hitPos;
        BlockHitResult result = CoordUtils.branchRayTrace(level, species, treePos, branchPos, 45.0f, 60.0f, 4 + level.getRandom().nextInt(3));
        if (result != null && (hitPos = BlockPos.containing((Position)result.getLocation())) != BlockPos.ZERO) {
            do {
                hitPos = hitPos.below();
            } while (species.getFamily().isCompatibleGenericLeaves(species, level.getBlockState(hitPos), level, hitPos));
            if (level.isEmptyBlock(hitPos)) {
                return hitPos;
            }
        }
        return BlockPos.ZERO;
    }

    @Nullable
    public static BlockHitResult branchRayTrace(LevelAccessor level, Species species, BlockPos treePos, BlockPos branchPos, float spreadHor, float spreadVer, float distance) {
        treePos = new BlockPos(treePos.getX(), branchPos.getY(), treePos.getZ());
        Vec3 vOut = new Vec3((double)(branchPos.getX() - treePos.getX()), 0.0, (double)(branchPos.getZ() - treePos.getZ()));
        if (vOut.equals((Object)Vec3.ZERO)) {
            vOut = new Vec3(1.0, 0.0, 0.0);
            spreadHor = 180.0f;
        }
        float deltaYaw = level.getRandom().nextFloat() * spreadHor * 2.0f - spreadHor;
        float deltaPitch = level.getRandom().nextFloat() * -spreadVer;
        vOut = vOut.normalize().add(0.0, Math.tan(Math.toRadians(deltaPitch)), 0.0).normalize().yRot((float)Math.toRadians(deltaYaw)).scale((double)distance);
        Vec3 branchVec = new Vec3((double)branchPos.getX(), (double)branchPos.getY(), (double)branchPos.getZ()).add(0.5, 0.5, 0.5);
        Vec3 vantageVec = branchVec.add(vOut);
        BlockPos vantagePos = BlockPos.containing((Position)vantageVec);
        if (level.isEmptyBlock(vantagePos)) {
            BlockHitResult result = CoordUtils.rayTraceBlocks(level, new CustomRayTraceContext(vantageVec, branchVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE));
            BlockPos hitPos = BlockPos.containing((Position)result.getLocation());
            if (result.getType() == HitResult.Type.BLOCK && !hitPos.equals((Object)BlockPos.ZERO) && species.getFamily().isCompatibleGenericLeaves(species, level.getBlockState(hitPos), level, hitPos)) {
                return result;
            }
        }
        return null;
    }

    public static BlockHitResult rayTraceBlocks(LevelAccessor level, CustomRayTraceContext context) {
        return CoordUtils.getRayTraceVector(context, (fromContext, blockPos) -> {
            BlockState blockstate = level.getBlockState(blockPos);
            FluidState fluidState = level.getFluidState(blockPos);
            Vec3 startVec = fromContext.getStartVector();
            Vec3 endVec = fromContext.getEndVector();
            VoxelShape voxelshape = fromContext.getBlockShape(blockstate, (BlockGetter)level, (BlockPos)blockPos);
            BlockHitResult blockraytraceresult = level.clipWithInteractionOverride(startVec, endVec, blockPos, voxelshape, blockstate);
            VoxelShape voxelshape1 = fromContext.getFluidShape(fluidState, (BlockGetter)level, (BlockPos)blockPos);
            BlockHitResult blockraytraceresult1 = voxelshape1.clip(startVec, endVec, blockPos);
            double d0 = blockraytraceresult == null ? Double.MAX_VALUE : fromContext.getStartVector().distanceToSqr(blockraytraceresult.getLocation());
            double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : fromContext.getStartVector().distanceToSqr(blockraytraceresult1.getLocation());
            return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
        }, context1 -> {
            Vec3 vec3d = context1.getStartVector().subtract(context1.getEndVector());
            return BlockHitResult.miss((Vec3)context1.getEndVector(), (Direction)Direction.getNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)BlockPos.containing((Position)context1.getEndVector()));
        });
    }

    private static <T> T getRayTraceVector(CustomRayTraceContext context, BiFunction<CustomRayTraceContext, BlockPos, T> biFunction, Function<CustomRayTraceContext, T> function) {
        int k;
        int j;
        Vec3 endVec;
        Vec3 startVec = context.getStartVector();
        if (startVec.equals((Object)(endVec = context.getEndVector()))) {
            return function.apply(context);
        }
        double vantX = Mth.lerp((double)-1.0E-7, (double)endVec.x, (double)startVec.x);
        double vantY = Mth.lerp((double)-1.0E-7, (double)endVec.y, (double)startVec.y);
        double vantZ = Mth.lerp((double)-1.0E-7, (double)endVec.z, (double)startVec.z);
        double lookX = Mth.lerp((double)-1.0E-7, (double)startVec.x, (double)endVec.x);
        double lookY = Mth.lerp((double)-1.0E-7, (double)startVec.y, (double)endVec.y);
        double lookZ = Mth.lerp((double)-1.0E-7, (double)startVec.z, (double)endVec.z);
        int i = Mth.floor((double)lookX);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i, j = Mth.floor((double)lookY), k = Mth.floor((double)lookZ));
        T t = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos);
        if (t != null) {
            return t;
        }
        double d6 = vantX - lookX;
        double d7 = vantY - lookY;
        double d8 = vantZ - lookZ;
        int l = Mth.sign((double)d6);
        int i1 = Mth.sign((double)d7);
        int j1 = Mth.sign((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.frac((double)lookX) : Mth.frac((double)lookX));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.frac((double)lookY) : Mth.frac((double)lookY));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.frac((double)lookZ) : Mth.frac((double)lookZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos.set(i, j, k))) == null) continue;
            return t1;
        }
        return function.apply(context);
    }

    public static BlockPos findWorldSurface(LevelAccessor level, BlockPos startPos, boolean worldGen) {
        return CoordUtils.findWorldSurface(level, startPos, worldGen ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.WORLD_SURFACE);
    }

    public static BlockPos findWorldSurface(LevelAccessor level, BlockPos startPos, Heightmap.Types heightmap) {
        return new BlockPos(startPos.getX(), level.getHeight(heightmap, startPos.getX(), startPos.getZ()) - 1, startPos.getZ());
    }

    public static boolean inRange(BlockPos pos, int minY, int maxY) {
        return pos.getY() >= minY && pos.getY() <= maxY;
    }

    public static int coordHashCode(BlockPos pos, int a, int b, int c) {
        int hash = (pos.getX() * a ^ pos.getY() * b ^ pos.getZ() * c) >> 1;
        return (hash ^ coordXor) & 0xFFFF;
    }

    public static int coordHashCode(BlockPos pos, int readyMade) {
        int[] factors = coordHashMap[readyMade & 3];
        return CoordUtils.coordHashCode(pos, factors[0], factors[1], factors[2]);
    }

    public static Iterable<BlockPos> goHorSides(BlockPos pos) {
        return CoordUtils.goHorSides(pos, null);
    }

    public static Iterable<BlockPos> goHorSides(final BlockPos pos, final @Nullable Direction ignore) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int currentDir = 0;

                    protected BlockPos computeNext() {
                        while (this.currentDir < HORIZONTALS.length) {
                            Direction face;
                            if ((face = HORIZONTALS[this.currentDir++]) == ignore) continue;
                            return pos.relative(face);
                        }
                        return (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    private static class CustomRayTraceContext {
        private final Vec3 startVec;
        private final Vec3 endVec;
        private final ClipContext.Block blockMode;
        private final ClipContext.Fluid fluidMode;

        public CustomRayTraceContext(Vec3 startVecIn, Vec3 endVecIn, ClipContext.Block blockModeIn, ClipContext.Fluid fluidModeIn) {
            this.startVec = startVecIn;
            this.endVec = endVecIn;
            this.blockMode = blockModeIn;
            this.fluidMode = fluidModeIn;
        }

        public Vec3 getEndVector() {
            return this.endVec;
        }

        public Vec3 getStartVector() {
            return this.startVec;
        }

        public VoxelShape getBlockShape(BlockState state, BlockGetter level, BlockPos pos) {
            return this.blockMode.get(state, level, pos, CollisionContext.empty());
        }

        public VoxelShape getFluidShape(FluidState state, BlockGetter level, BlockPos pos) {
            return this.fluidMode.canPick(state) ? state.getShape(level, pos) : Shapes.empty();
        }
    }

    public static enum Surround implements StringRepresentable
    {
        N("n", Direction.NORTH),
        NW("nw", Direction.NORTH, Direction.WEST),
        W("w", Direction.WEST),
        SW("sw", Direction.SOUTH, Direction.WEST),
        S("s", Direction.SOUTH),
        SE("se", Direction.SOUTH, Direction.EAST),
        E("e", Direction.EAST),
        NE("ne", Direction.NORTH, Direction.EAST);

        private final String name;
        private final Vec3i offset;

        private Surround(String name, Direction ... dirs) {
            this.name = name;
            BlockPos pos = BlockPos.ZERO;
            for (Direction d : dirs) {
                pos = pos.offset(d.getNormal());
            }
            this.offset = pos;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Vec3i getOffset() {
            return this.offset;
        }

        public BlockPos getOffsetPos() {
            return new BlockPos(this.offset);
        }

        public Surround getOpposite() {
            return Surround.values()[this.ordinal() + 4 & 7];
        }
    }
}

