/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.utility;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    public static void spawnItemStack(Level level, BlockPos pos, ItemStack stack) {
        ItemUtils.spawnItemStack(level, pos, stack, false);
    }

    public static void spawnItemStack(Level level, BlockPos pos, ItemStack stack, boolean searchForAir) {
        if (searchForAir) {
            while (!level.isEmptyBlock(pos)) {
                pos = pos.above();
            }
        }
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
        itemEntity.setDeltaMovement(0.0, 0.0, 0.0);
        level.addFreshEntity((Entity)itemEntity);
    }

    public static void damageAxe(LivingEntity entity, @Nullable ItemStack heldItem, int radius, NetVolumeNode.Volume woodVolume, boolean forBlockBreak) {
        int damage;
        if (heldItem == null || !Services.INTERACTION.canToolAxeDig(heldItem)) {
            return;
        }
        switch (Services.CONFIG.getEnumConfig("axeDamageMode", DynamicTrees.AxeDamage.class)) {
            default: {
                throw new MatchException(null, null);
            }
            case VANILLA: {
                int n = 1;
                break;
            }
            case THICKNESS: {
                int n = Math.max(1, radius) / 2;
                break;
            }
            case VOLUME: {
                int n = damage = (int)woodVolume.getVolume();
            }
        }
        if (forBlockBreak) {
            --damage;
        }
        if (damage > 0) {
            heldItem.hurtAndBreak(damage, entity, EquipmentSlot.MAINHAND);
        }
    }

    public static int getEnchantmentLevel(ResourceKey<Enchantment> enchantment, ItemStack stack, RegistryAccess registryAccess) {
        return EnchantmentHelper.getItemEnchantmentLevel(ItemUtils.getEnchantment(enchantment, (HolderLookup.Provider)registryAccess), (ItemStack)stack);
    }

    public static Holder.Reference<Enchantment> getEnchantment(ResourceKey<Enchantment> enchantment, HolderLookup.Provider registryAccess) {
        HolderLookup.RegistryLookup registrylookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        return registrylookup.getOrThrow(enchantment);
    }
}

