/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.utility;

import net.minecraft.util.RandomSource;

public class MathUtils {
    public static int selectRandomFromDistribution(RandomSource random, int[] distMap) {
        int distSize = 0;
        for (int j : distMap) {
            distSize += j;
        }
        if (distSize <= 0) {
            return -1;
        }
        int rnd = random.nextInt(distSize) + 1;
        for (int i = 0; i < 6; ++i) {
            if (rnd > distMap[i]) {
                rnd -= distMap[i];
                continue;
            }
            return i;
        }
        return 0;
    }

    public static float shortDegreesDist(float ang1, float ang2) {
        float max = 360.0f;
        float da = (ang2 - ang1) % 360.0f;
        return 2.0f * da % 360.0f - da;
    }

    public static float angleDegreesInterpolate(float ang1, float ang2, float t) {
        return ang1 + MathUtils.shortDegreesDist(ang1, ang2) * t;
    }

    public static int randomBetween(RandomSource random, int min, int max) {
        if (min == max) {
            return min;
        }
        return min + random.nextInt(1 + max - min);
    }
}

