/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.utility;

import com.dtteam.dynamictrees.DynamicTrees;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public final class ResourceLocationUtils {
    public static ResourceLocation parse(String string, String defaultNamespace) {
        if (!((String)string).contains(":")) {
            string = defaultNamespace + ":" + (String)string;
        }
        return ResourceLocation.parse((String)string);
    }

    public static ResourceLocation namespace(ResourceLocation resourceLocation, String namespace) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)resourceLocation.getPath());
    }

    public static ResourceLocation prefix(ResourceLocation resourceLocation, String prefix) {
        return ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)(prefix + resourceLocation.getPath()));
    }

    public static ResourceLocation suffix(ResourceLocation resourceLocation, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)(resourceLocation.getPath() + suffix));
    }

    public static ResourceLocation surround(ResourceLocation resourceLocation, String prefix, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)(prefix + resourceLocation.getPath() + suffix));
    }

    public static ResourceLocation parseDTLocation(String resLocString) {
        return Optional.ofNullable(ResourceLocation.tryParse((String)resLocString)).orElse(DynamicTrees.NULL);
    }

    public static ResourceLocation parseDTLocation(ResourceLocation resourceLocation) {
        return "minecraft".equals(resourceLocation.getNamespace()) ? DynamicTrees.location(resourceLocation.getPath()) : resourceLocation;
    }
}

