/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.cell.LeafClusters;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.nodemapper.CoderNode;
import com.dtteam.dynamictrees.systems.nodemapper.CollectorNode;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.feature.DynamicTreeFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoCode {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    protected static final byte FORK_CODE = 6;
    protected static final byte RETURN_CODE = 7;
    public byte[] instructions = new byte[0];
    protected boolean careful = false;
    private final byte[][] dirmap = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 3, 2, 5, 4, 6, 7}, {0, 1, 5, 4, 2, 3, 6, 7}, {0, 1, 4, 5, 3, 2, 6, 7}};
    private byte[] facingMap = this.dirmap[2];
    private byte[] unfacingMap = this.dirmap[2];

    public JoCode(Level level, BlockPos rootPos, Direction facing) {
        this.getCodeFromWorld(level, rootPos, facing);
    }

    protected void getCodeFromWorld(Level level, BlockPos rootPos, Direction facing) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.getBlockState(rootPos.above()));
        if (branch.isPresent()) {
            CoderNode coder = new CoderNode();
            branch.get().analyse(level.getBlockState(rootPos), (LevelAccessor)level, rootPos, Direction.DOWN, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    public JoCode(Level level, BlockPos pos) {
        this(level, pos, Direction.SOUTH);
    }

    public JoCode(String code) {
        this.instructions = JoCode.decode(code);
    }

    public JoCode setCareful(boolean c) {
        this.careful = c;
        return this;
    }

    protected int getCode(int pos) {
        return this.unfacingMap[this.instructions[pos]];
    }

    public JoCode setFacing(Direction facing) {
        int faceNum = facing.ordinal();
        this.facingMap = this.dirmap[faceNum];
        faceNum = faceNum == 4 ? 5 : (faceNum == 5 ? 4 : faceNum);
        this.unfacingMap = this.dirmap[faceNum];
        return this;
    }

    public JoCode rotate(Direction dir) {
        this.setFacing(dir);
        for (int c = 0; c < this.instructions.length; ++c) {
            this.instructions[c] = this.facingMap[this.instructions[c]];
        }
        return this;
    }

    public void generate(DynamicTreeGenerationContext context) {
        LevelAccessor level = context.level();
        Species species = context.species();
        int radius = context.radius();
        boolean worldGen = context.isWorldGen();
        this.setFacing(context.facing());
        context.rootPos().set((Vec3i)species.preGeneration(level, context.rootPos(), radius, context.facing(), context.isWorldGen(), this));
        BlockPos.MutableBlockPos rootPos = context.rootPos();
        if (rootPos == BlockPos.ZERO) {
            return;
        }
        BlockState initialDirtState = level.getBlockState((BlockPos)rootPos);
        species.placeRootyDirtBlock(level, (BlockPos)rootPos, 0);
        this.generateFork(level, species, 0, (BlockPos)rootPos, false);
        BlockPos treePos = rootPos.above();
        BlockState treeState = level.getBlockState(treePos);
        BranchBlock firstBranch = TreeHelper.getBranch(treeState);
        if (firstBranch == null) {
            level.setBlock((BlockPos)rootPos, initialDirtState, this.careful ? 3 : 2);
            return;
        }
        SimpleVoxmap leafCluster = species.getLeavesProperties().getCellKit().getLeafCluster();
        int leafMapXLen = radius * 2 + leafCluster.getLenX();
        int leafMapZLen = radius * 2 + leafCluster.getLenZ();
        SimpleVoxmap leafMap = new SimpleVoxmap(leafMapXLen, species.getWorldGenLeafMapHeight(), leafMapZLen).setMapAndCenter(treePos, new BlockPos(leafMapXLen / 2, 0, leafMapZLen / 2));
        NodeInspector inflator = species.getNodeInflator(leafMap);
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(inflator, endFinder);
        signal.destroyLoopedNodes = this.careful;
        firstBranch.analyse(treeState, level, treePos, Direction.DOWN, signal);
        if (signal.foundRoot || signal.overflow) {
            this.tryGenerateAgain(context, worldGen, treePos, treeState, endFinder);
            return;
        }
        this.generateAndAgeLeaves(context, leafMap, worldGen);
        List<BlockPos> endPoints = endFinder.getEnds();
        if (species.handleRot(level, endPoints, (BlockPos)rootPos, treePos, 0, worldGen)) {
            return;
        }
        PostGenerationContext pgContext = new PostGenerationContext(context, endPoints, initialDirtState);
        species.postGeneration(pgContext);
        Services.EVENT.postSpeciesPostGenerationEvent(pgContext);
        this.addSnow(leafMap, level, (BlockPos)rootPos, context.biome());
    }

    protected void generateAndAgeLeaves(DynamicTreeGenerationContext context, SimpleVoxmap leafMap, boolean worldGen) {
        LevelAccessor level = context.level();
        Species species = context.species();
        LeavesProperties leavesProperties = species.getLeavesProperties();
        this.smother(leafMap, leavesProperties);
        for (SimpleVoxmap.VoxmapCell cell : leafMap.getAllNonZeroCells((byte)15)) {
            BlockPos.MutableBlockPos cellPos = cell.getPos();
            BlockState testBlockState = level.getBlockState((BlockPos)cellPos);
            if (!this.isReplaceable(testBlockState, true) && !testBlockState.is(BlockTags.LEAVES)) continue;
            level.setBlock((BlockPos)cellPos, leavesProperties.getDynamicLeavesState(cell.getValue()), worldGen ? 16 : 2);
        }
        TreeHelper.ageVolume(level, leafMap, species.getWorldGenAgeIterations(), worldGen);
    }

    protected void tryGenerateAgain(DynamicTreeGenerationContext context, boolean worldGen, BlockPos treePos, BlockState treeState, FindEndsNode endFinder) {
        if (worldGen) {
            if (!context.secondChanceRegen()) {
                LOGGER.debug("Non-viable branch network detected during world generation @ {}", (Object)treePos);
                LOGGER.debug("Species: {}", (Object)context.species());
                LOGGER.debug("Radius: {}", (Object)context.radius());
                LOGGER.debug("JoCode: {}", (Object)this);
            } else {
                LOGGER.debug("Second attempt for code {} has also failed", (Object)this);
            }
        }
        this.cleanupFrankentree(context.levelContext().accessor(), treePos, treeState, endFinder.getEnds(), context.isWorldGen());
        if (!context.secondChanceRegen()) {
            context.secondChance();
            this.generate(context);
        }
    }

    protected void cleanupFrankentree(LevelAccessor level, BlockPos treePos, BlockState treeState, List<BlockPos> endPoints, boolean worldGen) {
        HashSet<BlockPos> blocksToDestroy = new HashSet<BlockPos>();
        BranchBlock branch = TreeHelper.getBranch(treeState);
        MapSignal signal = new MapSignal(new CollectorNode(blocksToDestroy));
        signal.destroyLoopedNodes = false;
        signal.trackVisited = true;
        assert (branch != null);
        branch.analyse(treeState, level, treePos, null, signal);
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.IGNORE;
        for (BlockPos pos : blocksToDestroy) {
            BlockState branchState = level.getBlockState(pos);
            Optional<BranchBlock> branchBlock = TreeHelper.getBranchOpt(branchState);
            if (branchBlock.isEmpty()) continue;
            int radius = branchBlock.get().getRadius(branchState);
            Family family = branchBlock.get().getFamily();
            Species species = family.getCommonSpecies();
            if (family.getPrimaryThickness() == radius) {
                species.getLeavesProperties().ifValid(leavesProperties -> {
                    SimpleVoxmap leafCluster = leavesProperties.getCellKit().getLeafCluster();
                    if (leafCluster != LeafClusters.NULL_MAP) {
                        for (SimpleVoxmap.VoxmapCell cell : leafCluster.getAllNonZeroCells()) {
                            BlockPos delPos = pos.offset((Vec3i)cell.getPos());
                            BlockState leavesState = level.getBlockState(delPos);
                            if (!TreeHelper.isLeaves(leavesState)) continue;
                            DynamicLeavesBlock leavesBlock = (DynamicLeavesBlock)leavesState.getBlock();
                            if (leavesProperties.getFamily() != leavesBlock.getLeavesProperties().getFamily()) continue;
                            level.setBlock(delPos, Blocks.AIR.defaultBlockState(), 2);
                        }
                    }
                });
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.HARVEST;
    }

    protected int generateFork(LevelAccessor level, Species species, int codePos, BlockPos pos, boolean disabled) {
        block4: while (codePos < this.instructions.length) {
            int code = this.getCode(codePos);
            switch (code) {
                case 6: {
                    codePos = this.generateFork(level, species, codePos + 1, pos, disabled);
                    continue block4;
                }
                case 7: {
                    return codePos + 1;
                }
            }
            Direction dir = Direction.from3DDataValue((int)code);
            pos = pos.relative(dir);
            if (!disabled) {
                disabled = this.setBlockForGeneration(level, species, pos, dir, this.careful, codePos + 1 == this.instructions.length);
            }
            ++codePos;
        }
        return codePos;
    }

    protected boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
        if (this.isFreeToSetBlock(level, pos, species) && (!careful || this.isClearOfNearbyBranches(level, pos, dir.getOpposite()))) {
            species.getFamily().getBranchForPlacement(level, species, pos).ifPresent(branch -> branch.setRadius(level, pos, species.getFamily().getPrimaryThickness(), null, careful ? 3 : 2));
            return false;
        }
        return true;
    }

    protected boolean isFreeToSetBlock(LevelAccessor level, BlockPos pos, Species species) {
        if (DynamicTreeFeature.validTreePos((LevelSimulatedReader)level, pos) || level.isStateAtPosition(pos, blockState -> blockState.is(BlockTags.LOGS))) {
            return true;
        }
        BlockState blockState2 = level.getBlockState(pos);
        return !blockState2.getFluidState().isEmpty() || this.isReplaceable(blockState2, false);
    }

    protected boolean isReplaceable(BlockState state, boolean airOnly) {
        boolean isEmpty = airOnly ? state.isAir() : state.canBeReplaced();
        return isEmpty || state.is(DTBlockTags.FOLIAGE) || state.is(BlockTags.FLOWERS);
    }

    protected void smother(SimpleVoxmap leafMap, LeavesProperties leavesProperties) {
        int smotherMax = leavesProperties.getSmotherLeavesMax();
        if (smotherMax == 0) {
            return;
        }
        BlockPos saveCenter = leafMap.getCenter();
        leafMap.setCenter(new BlockPos(0, 0, 0));
        for (int startY = leafMap.getLenY() - 1; startY >= 0 && !leafMap.isYTouched(startY); --startY) {
        }
        for (int iz = 0; iz < leafMap.getLenZ(); ++iz) {
            for (int ix = 0; ix < leafMap.getLenX(); ++ix) {
                int count = 0;
                for (int iy = startY; iy >= 0; --iy) {
                    byte v = leafMap.getVoxel(new BlockPos(ix, iy, iz));
                    if (v == 0) {
                        count = 0;
                        continue;
                    }
                    if ((v & 0xF) != 0) {
                        if (++count <= smotherMax) continue;
                        leafMap.setVoxel(new BlockPos(ix, iy, iz), (byte)0);
                        continue;
                    }
                    if ((v & 0x10) == 0) continue;
                    ++count;
                    leafMap.setVoxel(new BlockPos(ix, iy + 1, iz), (byte)4);
                }
            }
        }
        leafMap.setCenter(saveCenter);
    }

    protected boolean isClearOfNearbyBranches(LevelAccessor level, BlockPos pos, Direction except) {
        for (Direction dir : Direction.values()) {
            if (dir == except || TreeHelper.getBranch(level.getBlockState(pos.relative(dir))) == null) continue;
            return false;
        }
        return true;
    }

    protected void addSnow(SimpleVoxmap leafMap, LevelAccessor level, BlockPos rootPos, Holder<Biome> biome) {
        if (((Biome)biome.value()).getBaseTemperature() >= 0.4f) {
            return;
        }
        block0: for (BlockPos.MutableBlockPos top : leafMap.getTops()) {
            if (!((Biome)level.getUncachedNoiseBiome(rootPos.getX() >> 2, rootPos.getY() >> 2, rootPos.getZ() >> 2).value()).shouldSnow((LevelReader)level, rootPos)) continue;
            BlockPos.MutableBlockPos iPos = new BlockPos.MutableBlockPos(top.getX(), top.getY(), top.getZ());
            int yOffset = 0;
            do {
                BlockState state;
                if ((state = level.getBlockState((BlockPos)iPos)).isAir()) {
                    level.setBlock((BlockPos)iPos, Blocks.SNOW.defaultBlockState(), 2);
                    continue block0;
                }
                if (state.getBlock() == Blocks.SNOW) continue block0;
                iPos.setY(iPos.getY() + 1);
            } while (yOffset++ < 4);
        }
    }

    public static String encode(byte[] array) {
        ArrayList<Byte> instructions = new ArrayList<Byte>(array.length + (array.length & 1));
        for (byte b : array) {
            instructions.add(b);
        }
        if ((instructions.size() & 1) == 1) {
            instructions.add((byte)7);
        }
        StringBuilder code = new StringBuilder();
        for (int b = 0; b < instructions.size(); b += 2) {
            code.append(BASE_64.charAt((Byte)instructions.get(b) << 3 | (Byte)instructions.get(b + 1)));
        }
        return code.toString();
    }

    public static byte[] decode(String code) {
        return new CodeCompiler(code).compile();
    }

    public String toString() {
        return JoCode.encode(this.instructions);
    }

    public Component getTextComponent() {
        return Component.literal((String)this.toString()).withStyle(style -> style.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.copy.click"))));
    }

    public static class CodeCompiler {
        final ArrayList<Byte> instructions;

        public CodeCompiler() {
            this.instructions = new ArrayList();
        }

        public CodeCompiler(int size) {
            this.instructions = new ArrayList(size);
        }

        public CodeCompiler(String code) {
            this.instructions = new ArrayList(code.length() * 2);
            for (int i = 0; i < code.length(); ++i) {
                int sixbits = JoCode.BASE_64.indexOf(code.charAt(i));
                if (sixbits == -1) continue;
                this.addInstruction((byte)(sixbits >> 3));
                this.addInstruction((byte)(sixbits & 7));
            }
        }

        public void addDirection(byte dir) {
            if (dir >= 0) {
                this.instructions.add((byte)(dir & 7));
            }
        }

        public void addInstruction(byte instruction) {
            this.instructions.add(instruction);
        }

        public void addReturn() {
            this.instructions.add((byte)7);
        }

        public void addFork() {
            this.instructions.add((byte)6);
        }

        public byte[] compile() {
            byte[] array = new byte[this.instructions.size()];
            Iterator<Byte> i = this.instructions.iterator();
            int pos = 0;
            while (i.hasNext()) {
                array[pos++] = i.next();
            }
            return array;
        }
    }
}

