/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.api.worldgen.GroundFinder;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public final class OverworldGroundFinder
implements GroundFinder {
    @Override
    public List<BlockPos> findGround(LevelAccessor level, BlockPos start, @Nullable Heightmap.Types heightmap) {
        LinkedList<BlockPos> surfaceGround = new LinkedList<BlockPos>(SURFACE.findGround(level, start, heightmap));
        BlockPos surfaceBlock = surfaceGround.getFirst();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(start.getX(), 0, start.getZ());
        boolean caveBiomeFound = false;
        while (CoordUtils.inRange((BlockPos)pos, level.getMinBuildHeight(), surfaceBlock.getY())) {
            if (level.getBiome((BlockPos)pos).is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"c:is_underground")))) {
                caveBiomeFound = true;
                break;
            }
            pos.move(0, -10, 0);
        }
        if (caveBiomeFound) {
            List<BlockPos> subterraneanGround = SUBTERRANEAN.findGround(level, start, heightmap);
            surfaceGround.addAll(subterraneanGround);
            return new LinkedList<BlockPos>(surfaceGround);
        }
        return surfaceGround;
    }
}

