/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.biomemodifier;

import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.registry.NeoForgeRegistryLoader;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AddDynamicTreesBiomeModifier
implements BiomeModifier {
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && Services.CONFIG.getBoolConfig("worldGen").booleanValue()) {
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            Registry placedFeatures = ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
            generationSettings.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatures.getHolderOrThrow(DTRegistries.CAVE_ROOTED_TREE_PLACED_FEATURE));
            generationSettings.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatures.getHolderOrThrow(DTRegistries.DYNAMIC_TREE_PLACED_FEATURE));
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return NeoForgeRegistryLoader.ADD_DYNAMIC_TREES_BIOME_MODIFIER.get();
    }
}

