/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.holderset;

import com.dtteam.dynamictrees.worldgen.holderset.StreamBackedHolderSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;

public abstract class RegexMatchHolderSet<T>
extends StreamBackedHolderSet<T>
implements ICustomHolderSet<T> {
    private final HolderLookup.RegistryLookup<T> registryLookup;
    private final String regex;
    private Pattern pattern;

    protected static <T> MapCodec<? extends ICustomHolderSet<T>> mapCodec(ResourceKey<? extends Registry<T>> registryKey, BiFunction<HolderLookup.RegistryLookup<T>, String, RegexMatchHolderSet<T>> factory) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)registryKey).forGetter(RegexMatchHolderSet::registryLookup), (App)Codec.STRING.fieldOf("regex").forGetter(RegexMatchHolderSet::regex)).apply((Applicative)builder, factory));
    }

    public RegexMatchHolderSet(HolderLookup.RegistryLookup<T> registryLookup, String regex) {
        this.registryLookup = registryLookup;
        this.regex = regex;
    }

    public final HolderLookup.RegistryLookup<T> registryLookup() {
        return this.registryLookup;
    }

    public final String regex() {
        return this.regex;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    public Stream<Holder<T>> stream() {
        return this.registryLookup.listElements().filter(holder -> this.getInput((Holder<T>)holder).anyMatch(input -> this.getPattern().matcher((CharSequence)input).matches()));
    }

    public boolean canSerializeIn(HolderOwner<T> owner) {
        return this.registryLookup.canSerializeIn(owner);
    }

    protected abstract Stream<String> getInput(Holder<T> var1);
}

