/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.structure;

import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@MethodsReturnNonnullByDefault
public final class TreePoolElement
extends StructurePoolElement {
    public static final MapCodec<TreePoolElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Species.CODEC.fieldOf("species").forGetter(TreePoolElement::getSpecies), (App)BlockPos.CODEC.optionalFieldOf("offset", (Object)BlockPos.ZERO).forGetter(TreePoolElement::getOffset), (App)TreePoolElement.projectionCodec()).apply((Applicative)instance, TreePoolElement::new));
    private final Species species;
    private final BlockPos offset;
    private final CompoundTag defaultJigsawNBT;

    public TreePoolElement(Species species, StructureTemplatePool.Projection projection) {
        this(species, BlockPos.ZERO, projection);
    }

    public TreePoolElement(Species species, BlockPos offset, StructureTemplatePool.Projection projection) {
        super(projection);
        this.species = species;
        this.offset = offset;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    public static Function<StructureTemplatePool.Projection, TreePoolElement> create(Species species) {
        return projection -> new TreePoolElement(species, (StructureTemplatePool.Projection)projection);
    }

    public static Function<StructureTemplatePool.Projection, TreePoolElement> create(Species species, BlockPos offset) {
        return projection -> new TreePoolElement(species, offset, (StructureTemplatePool.Projection)projection);
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("name", "minecraft:bottom");
        tag.putString("final_state", "minecraft:air");
        tag.putString("pool", "minecraft:empty");
        tag.putString("target", "minecraft:empty");
        tag.putString("joint", JigsawBlockEntity.JointType.ROLLABLE.getSerializedName());
        return tag;
    }

    public List<StructureTemplate.StructureBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager structureManager, BlockPos pos, Rotation rotation, RandomSource random) {
        return Lists.newArrayList((Object[])new StructureTemplate.StructureBlockInfo[]{new StructureTemplate.StructureBlockInfo(pos, (BlockState)Blocks.JIGSAW.defaultBlockState().setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT)});
    }

    public BoundingBox getBoundingBox(StructureTemplateManager structureManager, BlockPos pos, Rotation rotation) {
        return new BoundingBox(pos.getX(), pos.getY(), pos.getZ(), pos.getX(), pos.getY(), pos.getZ());
    }

    public Vec3i getSize(StructureTemplateManager pStructureManager, Rotation pRotation) {
        return Vec3i.ZERO;
    }

    public boolean place(StructureTemplateManager structureTemplateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos1, Rotation rotation, BoundingBox boundingBox, RandomSource randomSource, LiquidSettings liquidSettings, boolean b) {
        this.species.plantSapling((LevelAccessor)level, blockPos, true);
        return true;
    }

    private int getOffsetX(Rotation rotation) {
        return this.offset.getX() * (rotation.rotation().inverts(Direction.Axis.X) ? -1 : 1);
    }

    private int getOffsetY(Rotation rotation) {
        return this.offset.getY();
    }

    private int getOffsetZ(Rotation rotation) {
        return this.offset.getZ() * (rotation.rotation().inverts(Direction.Axis.Z) ? -1 : 1);
    }

    public StructurePoolElementType<?> getType() {
        return DTRegistries.TREE_STRUCTURE_POOL_ELEMENT_TYPE.get();
    }

    public Species getSpecies() {
        return this.species;
    }

    private BlockPos getOffset() {
        return this.offset;
    }
}

