/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.pod;

import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.block.pod.PodBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OffsetablePodBlock
extends PodBlock {
    public OffsetablePodBlock(BlockBehaviour.Properties properties, Pod pod) {
        super(properties, pod);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.pod != null) {
            builder.add(new Property[]{this.pod.getOffsetProperty()});
        }
        super.createBlockStateDefinition(builder);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        int rad = TreeHelper.getRadius((BlockGetter)context.getLevel(), context.getClickedPos());
        if (this.pod.isValidRadius(rad)) {
            return (BlockState)state.setValue((Property)this.pod.getOffsetProperty(), (Comparable)Integer.valueOf(rad));
        }
        return null;
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        int newOffset;
        Direction direction = (Direction)state.getValue((Property)FACING);
        int currentOffset = (Integer)state.getValue((Property)this.pod.getOffsetProperty());
        if (currentOffset != (newOffset = TreeHelper.getRadius((BlockGetter)level, pos.offset(direction.getNormal()))) && this.pod.isValidRadius(newOffset)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.pod.getOffsetProperty(), (Comparable)Integer.valueOf(newOffset)), 2);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        VoxelShape shape = super.getShape(state, level, pos, context);
        float mult = 0.0625f * (float)(8 - (Integer)state.getValue((Property)this.pod.getOffsetProperty()));
        return shape.move((double)((float)dir.getStepX() * mult), (double)((float)dir.getStepY() * mult), (double)((float)dir.getStepZ() * mult));
    }
}

