/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.client;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BlockColorMultipliers {
    private static Map<ResourceLocation, BlockColor> colorBase = new HashMap<ResourceLocation, BlockColor>();

    public static void register(String label, BlockColor colorMultiplier) {
        BlockColorMultipliers.register(ResourceLocationUtils.parse(label, "dynamictrees"), colorMultiplier);
    }

    public static void register(ResourceLocation label, BlockColor colorMultiplier) {
        if (colorBase == null) {
            DynamicTrees.LOG.error("Error registering Color Multiplier \"{}\". Called too late, block color multipliers have already been registered.", (Object)label);
        } else {
            colorBase.put(label, colorMultiplier);
        }
    }

    @Nullable
    public static BlockColor find(String label) {
        return BlockColorMultipliers.find(ResourceLocation.parse((String)label));
    }

    @Nullable
    public static BlockColor find(ResourceLocation label) {
        return colorBase.get(label);
    }

    public static void cleanUp() {
        colorBase = null;
    }
}

