/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.client;

import com.dtteam.dynamictrees.platform.Services;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class TextureHelper {
    public static int compose(int r, int g, int b, int a) {
        int rgb = a;
        rgb = (rgb << 8) + r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int compose(int[] c) {
        return c.length >= 4 ? TextureHelper.compose(c[0], c[1], c[2], c[3]) : 0;
    }

    public static int[] decompose(int c) {
        return new int[]{TextureHelper.red(c), TextureHelper.green(c), TextureHelper.blue(c), TextureHelper.alpha(c)};
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int blue(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int red(int c) {
        return c & 0xFF;
    }

    public static int avgColors(int[] pixels) {
        long rAccum = 0L;
        long gAccum = 0L;
        long bAccum = 0L;
        int count = 0;
        for (int i = 0; i < pixels.length; ++i) {
            int alpha = TextureHelper.alpha(pixels[i]);
            if (alpha < 128) continue;
            rAccum += (long)TextureHelper.red(pixels[i]);
            gAccum += (long)TextureHelper.green(pixels[i]);
            bAccum += (long)TextureHelper.blue(pixels[i]);
            ++count;
        }
        count = Math.max(1, count);
        int r = (int)(rAccum / (long)count);
        int g = (int)(gAccum / (long)count);
        int b = (int)(bAccum / (long)count);
        return TextureHelper.compose(r, g, b, 255);
    }

    public static class PixelBuffer {
        public int[] pixels;
        public final int w;
        public final int h;

        public PixelBuffer(int w, int h) {
            this.w = w;
            this.h = h;
            this.pixels = new int[w * h];
        }

        public PixelBuffer(NativeImage image) {
            this.w = image.getWidth();
            this.h = image.getHeight();
            this.pixels = new int[this.w * this.h];
            for (int x = 0; x < this.w; ++x) {
                for (int y = 0; y < this.h; ++y) {
                    this.pixels[this.calcPos((int)x, (int)y)] = image.getPixelRGBA(x, y);
                }
            }
        }

        public PixelBuffer(TextureAtlasSprite sprite) {
            this.w = sprite.contents().width();
            this.h = sprite.contents().height();
            this.pixels = new int[this.w * this.h];
            for (int x = 0; x < this.w; ++x) {
                for (int y = 0; y < this.h; ++y) {
                    this.pixels[this.calcPos((int)x, (int)y)] = Services.MISC.getPixelRGBA(sprite, x, y);
                }
            }
        }

        public PixelBuffer(TextureAtlasSprite sprite, boolean copy) {
            this(sprite);
        }

        public PixelBuffer(PixelBuffer other) {
            this.w = other.w;
            this.h = other.h;
            this.pixels = Arrays.copyOf(other.pixels, other.pixels.length);
        }

        public NativeImage toNativeImage() {
            NativeImage image = new NativeImage(this.w, this.h, true);
            for (int x = 0; x < this.w; ++x) {
                for (int y = 0; y < this.h; ++y) {
                    image.setPixelRGBA(x, y, this.getPixel(x, y));
                }
            }
            return image;
        }

        public int calcPos(int offX, int offY) {
            return offY * this.w + offX;
        }

        public int getPixel(int offX, int offY) {
            if (offX >= 0 && offX < this.w && offY >= 0 && offY < this.h) {
                return this.pixels[this.calcPos(offX, offY)];
            }
            return 0;
        }

        public void setPixel(int offX, int offY, int pixel) {
            if (offX >= 0 && offX < this.w && offY >= 0 && offY < this.h) {
                this.pixels[this.calcPos((int)offX, (int)offY)] = pixel;
            }
        }

        public void blit(PixelBuffer dst, int offX, int offY) {
            this.blit(dst, offX, offY, 0);
        }

        public void blit(PixelBuffer dst, int offX, int offY, int rotCW90) {
            switch (rotCW90 & 3) {
                case 0: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            dst.setPixel(x + offX, y + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 1: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destX = this.h - y - 1;
                            dst.setPixel(destX + offX, x + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 2: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destX = this.w - x - 1;
                            int destY = this.h - y - 1;
                            dst.setPixel(destX + offX, destY + offY, this.getPixel(x, y));
                        }
                    }
                    return;
                }
                case 3: {
                    for (int y = 0; y < this.h; ++y) {
                        for (int x = 0; x < this.w; ++x) {
                            int destY = this.w - x - 1;
                            dst.setPixel(y + offX, destY + offY, this.getPixel(x, y));
                        }
                    }
                    break;
                }
            }
        }

        public int averageColor() {
            return TextureHelper.avgColors(this.pixels);
        }

        public void grayScale() {
            for (int i = 0; i < this.pixels.length; ++i) {
                int a = TextureHelper.alpha(this.pixels[i]);
                int r = TextureHelper.red(this.pixels[i]);
                int g = TextureHelper.green(this.pixels[i]);
                int b = TextureHelper.blue(this.pixels[i]);
                int gray = (r * 30 + g * 59 + b * 11) / 100;
                this.pixels[i] = TextureHelper.compose(gray, gray, gray, a);
            }
        }

        public void fill(int color) {
            Arrays.fill(this.pixels, color);
        }
    }
}

