/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization;

import com.dtteam.dynamictrees.tree.species.Species;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class JsonMath {
    public MathOperator rootOp;
    public static final MathOperator NULL_OPERATOR = new Null();

    public JsonMath(JsonElement mathElement) {
        if (mathElement.isJsonObject()) {
            JsonObject mathObject = mathElement.getAsJsonObject();
            for (Map.Entry entry : mathObject.entrySet()) {
                this.rootOp = this.processElement((String)entry.getKey(), (JsonElement)entry.getValue());
                if (this.rootOp == NULL_OPERATOR) continue;
                return;
            }
        }
    }

    private MathOperator getVariable(String name) {
        if (MathFunction.NOISE.name.equals(name)) {
            return new Noise();
        }
        if (MathFunction.RAND.name.equals(name)) {
            return new Rand();
        }
        if (MathFunction.RADIUS.name.equals(name)) {
            return new Radius();
        }
        return NULL_OPERATOR;
    }

    private MathOperator processElement(String key, JsonElement value) {
        MathFunction op = MathFunction.getFunction(key);
        if (op == null) {
            return NULL_OPERATOR;
        }
        ArrayList<MathOperator> paramList = new ArrayList<MathOperator>();
        Species speciesArg = Species.NULL_SPECIES;
        if (value.isJsonArray()) {
            for (JsonElement parameter : value.getAsJsonArray()) {
                MathOperator m = NULL_OPERATOR;
                if (parameter.isJsonObject()) {
                    Map.Entry entry = (Map.Entry)parameter.getAsJsonObject().entrySet().iterator().next();
                    m = this.processElement((String)entry.getKey(), (JsonElement)entry.getValue());
                } else if (parameter.isJsonPrimitive()) {
                    if (parameter.getAsJsonPrimitive().isNumber()) {
                        m = new Const(parameter.getAsFloat());
                    } else if (parameter.getAsJsonPrimitive().isString()) {
                        String name = parameter.getAsString();
                        MathOperator var = this.getVariable(name);
                        if (var != NULL_OPERATOR) {
                            m = var;
                        } else if (Species.findSpeciesSloppy(name) != Species.NULL_SPECIES) {
                            speciesArg = Species.findSpeciesSloppy(name);
                        }
                    }
                }
                if (m == NULL_OPERATOR) continue;
                paramList.add(m);
            }
        }
        MathOperator[] paramArray = paramList.toArray(new MathOperator[0]);
        return switch (op.ordinal()) {
            case 1 -> new Noise();
            case 2 -> new Rand();
            case 3 -> new Radius();
            case 4 -> new Adder(paramArray);
            case 5 -> new Subtractor(paramArray);
            case 6 -> new Multiplier(paramArray);
            case 7 -> new Divider(paramArray);
            case 9 -> new Maximum(paramArray);
            case 10 -> new Minimum(paramArray);
            case 11 -> new IfGreaterThan(paramArray);
            case 12 -> {
                if (speciesArg != Species.NULL_SPECIES) {
                    yield new IfSpecies(speciesArg, paramArray);
                }
                yield null;
            }
            case 13 -> new Debug(paramArray);
            default -> NULL_OPERATOR;
        };
    }

    public float apply(RandomSource random, float noise) {
        MathContext mc = new MathContext(noise, random);
        return this.rootOp.apply(mc);
    }

    public float apply(RandomSource random, Species species, float radius) {
        MathSpeciesContext mc = new MathSpeciesContext(random, species, radius);
        return this.rootOp.apply(mc);
    }

    public static interface MathOperator {
        public float apply(MathContext var1);
    }

    public static enum MathFunction {
        CONST,
        NOISE,
        RAND,
        RADIUS,
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        MAX,
        MIN,
        IFGT,
        SPECIES,
        DEBUG;

        public final String name = this.toString().toLowerCase(Locale.ENGLISH);

        @Nullable
        static MathFunction getFunction(String findName) {
            for (MathFunction fun : MathFunction.values()) {
                if (!fun.name.equals(findName)) continue;
                return fun;
            }
            return null;
        }
    }

    public static class Noise
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            return mc.noise;
        }
    }

    public static class Rand
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            return mc.rand.nextFloat();
        }
    }

    public static class Radius
    implements MathOperator {
        @Override
        public float apply(MathContext mc) {
            if (mc instanceof MathSpeciesContext) {
                return ((MathSpeciesContext)mc).radius;
            }
            return 0.0f;
        }
    }

    public static class Const
    implements MathOperator {
        private final float value;

        Const(float value) {
            this.value = value;
        }

        @Override
        public float apply(MathContext mc) {
            return this.value;
        }
    }

    public static class Adder
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Adder(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) + this.functions[1].apply(mc);
            }
            float r = 0.0f;
            for (MathOperator f : this.functions) {
                r += f.apply(mc);
            }
            return r;
        }
    }

    public static class Subtractor
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Subtractor(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) - this.functions[1].apply(mc);
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : r.floatValue() - v);
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Multiplier
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Multiplier(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) * this.functions[1].apply(mc);
            }
            float r = 1.0f;
            for (MathOperator f : this.functions) {
                r *= f.apply(mc);
            }
            return r;
        }
    }

    public static class Divider
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Divider(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) / this.functions[1].apply(mc);
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : r.floatValue() / v);
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Maximum
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Maximum(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return Math.max(this.functions[0].apply(mc), this.functions[1].apply(mc));
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : Math.max(r.floatValue(), v));
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class Minimum
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Minimum(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return Math.min(this.functions[0].apply(mc), this.functions[1].apply(mc));
            }
            Float r = null;
            for (MathOperator f : this.functions) {
                float v = f.apply(mc);
                r = Float.valueOf(r == null ? v : Math.min(r.floatValue(), v));
            }
            return r == null ? 0.0f : r.floatValue();
        }
    }

    public static class IfGreaterThan
    implements MathOperator {
        private final MathOperator[] functions;

        public IfGreaterThan(MathOperator[] functionArray) {
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.functions.length == 4) {
                return this.functions[0].apply(mc) > this.functions[1].apply(mc) ? this.functions[2].apply(mc) : this.functions[3].apply(mc);
            }
            return 0.0f;
        }
    }

    public static class IfSpecies
    implements MathOperator {
        private final MathOperator[] functions;
        private final Species species;

        public IfSpecies(Species species, MathOperator[] functionArray) {
            this.species = species;
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (mc instanceof MathSpeciesContext && this.functions.length == 2) {
                return ((MathSpeciesContext)mc).species == this.species ? this.functions[0].apply(mc) : this.functions[1].apply(mc);
            }
            return 0.0f;
        }
    }

    public static class Debug
    implements MathOperator {
        private final MathOperator[] functions;

        public Debug(MathOperator[] functionArray) {
            this.functions = functionArray;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.functions.length >= 1) {
                float val = this.functions[0].apply(mc);
                LogManager.getLogger().debug("Json Debug Value: " + val);
                return val;
            }
            return 0.0f;
        }
    }

    public static class MathContext {
        public float noise;
        public RandomSource rand;

        public MathContext(float noise, RandomSource random) {
            this.noise = noise;
            this.rand = random;
        }
    }

    public static class MathSpeciesContext
    extends MathContext {
        public float radius;
        public Species species;

        public MathSpeciesContext(RandomSource random, Species species, float radius) {
            super(0.0f, random);
            this.radius = radius;
            this.species = species;
        }
    }

    private static class Null
    implements MathOperator {
        private Null() {
        }

        @Override
        public float apply(MathContext mc) {
            return 0.0f;
        }
    }

    public static class Modulus
    implements MathOperator {
        private final MathOperator[] functions;
        private final boolean dual;

        public Modulus(MathOperator[] functionArray) {
            this.functions = functionArray;
            this.dual = this.functions.length == 2;
        }

        @Override
        public float apply(MathContext mc) {
            if (this.dual) {
                return this.functions[0].apply(mc) % this.functions[1].apply(mc);
            }
            return 0.0f;
        }
    }
}

