/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.api.configuration.Configurable;
import com.dtteam.dynamictrees.api.configuration.ConfigurableRegistryEntry;
import com.dtteam.dynamictrees.api.configuration.Configuration;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.configuration.ConfigurationTemplate;
import com.dtteam.dynamictrees.api.configuration.Properties;
import com.dtteam.dynamictrees.api.configuration.TemplateRegistry;
import com.dtteam.dynamictrees.deserialization.DeserializationException;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.JsonHelper;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.JsonResult;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ConfiguredDeserializer<T extends Configuration<T, C>, C extends Configurable>
implements JsonDeserializer<T> {
    private final String configurableName;
    private final Class<C> configurableClass;
    private final TemplateRegistry<T> templates;

    public ConfiguredDeserializer(String configurableName, Class<C> configurableClass, TemplateRegistry<T> templates) {
        this.configurableName = configurableName;
        this.configurableClass = configurableClass;
        this.templates = templates;
    }

    @Override
    public Result<T, JsonElement> deserialize(JsonElement jsonElement) {
        return JsonResult.forInput(jsonElement).mapIfType(String.class, (name, warningConsumer) -> {
            ConfigurationTemplate<T> template = this.getTemplate(ResourceLocationUtils.parse(name, "dynamictrees"));
            return (Configuration)template.apply(Properties.NONE).orElseThrow();
        }).elseMapIfType(this.configurableClass, configurable -> configurable.getDefaultConfiguration()).elseMapIfType(JsonObject.class, (object, warningConsumer) -> {
            ConfigurationTemplate<T> template = this.getTemplate(this.getTemplateName((JsonObject)object));
            JsonObject propertiesJson = JsonHelper.getOrDefault(object, "properties", JsonObject.class, new JsonObject());
            Properties properties = new Properties();
            StreamSupport.stream(template.getRegisteredProperties().spliterator(), false).forEach(property -> this.addProperty(properties, (ConfigurationProperty)property, propertiesJson, (Consumer<String>)warningConsumer));
            return (Configuration)template.apply(properties).orElseThrow();
        }).elseError(this::isConfigurationValid, this.configurableName + " couldn't be found from input \"{}\".");
    }

    private boolean isConfigurationValid(@Nullable T config) {
        return config != null && ((Configuration)config).getConfigurable() instanceof ConfigurableRegistryEntry && ((ConfigurableRegistryEntry)((Configuration)config).getConfigurable()).isValid();
    }

    private ConfigurationTemplate<T> getTemplate(ResourceLocation templateName) throws DeserializationException {
        return this.templates.get(templateName).orElseThrow(() -> new DeserializationException("No such template \"" + String.valueOf(templateName) + "\" for \"" + this.configurableName + "\"."));
    }

    private ResourceLocation getTemplateName(JsonObject json) throws DeserializationException {
        return JsonHelper.getAsOptional(json, "name", JsonDeserializers.DT_RESOURCE_LOCATION).orElseThrow(() -> new DeserializationException("Configurable must state name of template to use."));
    }

    private <V> void addProperty(Properties properties, ConfigurationProperty<V> property, JsonObject propertiesJson, Consumer<String> warningConsumer) {
        property.deserialise(propertiesJson).map(result -> result.ifSuccessOrElse(value -> properties.put(property, value), warningConsumer, warningConsumer));
    }
}

