/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;

public final class StaticFieldDeserializer<T>
implements JsonDeserializer<T> {
    private final Class<T> type;

    public StaticFieldDeserializer(Class<T> type) {
        this.type = type;
    }

    @Override
    public Result<T, JsonElement> deserialize(JsonElement jsonElement) {
        return JsonDeserializers.STRING.deserialize(jsonElement).map(string -> Stream.of(this.type.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && field.getName().equals(string)).findFirst().map(field -> {
            try {
                Object obj = field.get(null);
                if (this.type.isInstance(obj)) {
                    return this.type.cast(obj);
                }
            }
            catch (IllegalAccessException e) {
                LogManager.getLogger().warn("Tried to access field '" + field.getName() + "' illegally from class '" + this.type.getName() + "'.", (Throwable)e);
            }
            return null;
        }).orElse(null), "Could not get '" + this.type.getName() + "' from '{previous_value}'.");
    }
}

