/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity.render;

import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.model.FallingTreeEntityModel;
import com.dtteam.dynamictrees.model.FallingTreeEntityModelTrackerCache;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FallingTreeRenderer
extends EntityRenderer<FallingTreeEntity> {
    public FallingTreeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallingTreeEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (!entity.isClientBuilt() || !entity.shouldRender(entity.getX(), entity.getY(), entity.getX())) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
        FallingTreeEntityModel treeModel = FallingTreeEntityModelTrackerCache.getOrCreateModel(entity);
        if (treeModel == null) {
            return;
        }
        poseStack.pushPose();
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        entity.currentAnimationHandler.renderTransform(entity, entityYaw, partialTick, poseStack);
        treeModel.renderToBuffer(poseStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, 1);
        poseStack.popPose();
    }
}

