/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.item;

import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.RootsJoCode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class Staff
extends Item {
    public static final float REACH_DISTANCE = 512.0f;

    public Staff() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.RARITY, (Object)Rarity.RARE).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
        DTRegistries.CREATIVE_TAB_ITEMS.add(this);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.getBlock() instanceof BranchBlock || state.getBlock() instanceof TrunkShellBlock) {
            return 64.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.getBlock() instanceof BranchBlock || state.getBlock() instanceof TrunkShellBlock) {
            if (this.damage(stack)) {
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.isClientSide() || !pPlayer.isCreative()) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        ItemStack handItem = pPlayer.getItemInHand(pUsedHand).copy();
        HitResult hitResult = pPlayer.pick(512.0, 0.0f, false);
        if (hitResult.getType() == HitResult.Type.BLOCK && this.useOn(new UseOnContext(pPlayer, pUsedHand, (BlockHitResult)hitResult)) == InteractionResult.SUCCESS) {
            return InteractionResultHolder.success((Object)handItem);
        }
        return InteractionResultHolder.pass((Object)handItem);
    }

    public InteractionResult useOn(UseOnContext context) {
        Species species;
        Level level = context.getLevel();
        ItemStack heldStack = context.getPlayer().getItemInHand(context.getHand());
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (state.canBeReplaced() || state.is(DTBlockTags.FOLIAGE)) {
            pos = pos.below();
            state = level.getBlockState(pos);
        }
        BlockPos rootPos = TreeHelper.findRootNode(level, pos);
        TreePart treePart = TreeHelper.getTreePart(level.getBlockState(rootPos));
        if (!this.isReadOnly(heldStack) && treePart.isRootNode() && (species = TreeHelper.getExactSpecies(level, rootPos)).isValid()) {
            if (!context.getPlayer().isShiftKeyDown()) {
                String code = new JoCode(level, rootPos, context.getPlayer().getDirection()).toString();
                this.setCode(heldStack, code);
                String rootCode = new RootsJoCode(level, rootPos, context.getPlayer().getDirection()).toString();
                this.setRootsCode(heldStack, rootCode);
                if (level.isClientSide) {
                    Minecraft.getInstance().keyboardHandler.setClipboard(code);
                }
            }
            this.setSpecies(heldStack, species);
            return InteractionResult.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species.isValid() && species.isAcceptableSoil((LevelReader)level, pos, state)) {
            DynamicTreeGenerationContext generationContext = new DynamicTreeGenerationContext(LevelContext.create((LevelAccessor)level), species, pos, pos.mutable(), (Holder<Biome>)level.getBiome(pos), context.getPlayer().getDirection(), 8, false);
            species.getJoCode(this.getCode(heldStack)).setCareful(true).generate(generationContext);
            String rootsCode = this.getRootsCode(heldStack);
            if (!rootsCode.isEmpty()) {
                species.getRootsJoCode(rootsCode).setCareful(true).generate(generationContext);
            }
            if (this.hasMaxDamage(heldStack)) {
                if (this.damage(heldStack)) {
                    heldStack.shrink(1);
                }
            } else {
                heldStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean isBarVisible(ItemStack pStack) {
        return this.hasMaxDamage(pStack);
    }

    public int getBarWidth(ItemStack stack) {
        int damage = this.getDamage(stack) / this.getMaxDamage(stack);
        return 1 - damage;
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return itemStack.has(DTRegistries.READ_ONLY_DATA_COMPONENT.get());
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        itemStack.set(DTRegistries.READ_ONLY_DATA_COMPONENT.get(), (Object)Unit.INSTANCE);
        return this;
    }

    public void setSpecies(ItemStack itemStack, Species species) {
        String name = species.getRegistryName().toString();
        itemStack.set(DTRegistries.SPECIES_DATA_COMPONENT.get(), (Object)name);
    }

    public void setCode(ItemStack itemStack, String code) {
        itemStack.set(DTRegistries.JOCODE_DATA_COMPONENT.get(), (Object)code);
    }

    public void setRootsCode(ItemStack itemStack, String code) {
        itemStack.set(DTRegistries.ROOTS_JOCODE_DATA_COMPONENT.get(), (Object)code);
    }

    public Species getSpecies(ItemStack itemStack) {
        if (itemStack.has(DTRegistries.SPECIES_DATA_COMPONENT.get())) {
            return Species.findSpecies((String)itemStack.get(DTRegistries.SPECIES_DATA_COMPONENT.get()));
        }
        Species species = Species.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getDamage(ItemStack itemStack) {
        return Mth.clamp((int)((Integer)itemStack.getOrDefault(DataComponents.DAMAGE, (Object)0)), (int)0, (int)itemStack.getMaxDamage());
    }

    public void setDamage(ItemStack itemStack, int value) {
        itemStack.set(DataComponents.DAMAGE, (Object)value);
    }

    public int getMaxDamage(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(DataComponents.MAX_DAMAGE, (Object)0);
    }

    public void setMaxDamage(ItemStack itemStack, int value) {
        itemStack.set(DataComponents.MAX_DAMAGE, (Object)value);
    }

    public boolean hasMaxDamage(ItemStack itemStack) {
        if (itemStack.has(DataComponents.MAX_DAMAGE)) {
            return this.getMaxDamage(itemStack) != 0;
        }
        return false;
    }

    public boolean damage(ItemStack itemStack) {
        int maxDmg = this.getMaxDamage(itemStack);
        int dmg = Math.min(maxDmg, this.getDamage(itemStack) + 1);
        this.setDamage(itemStack, dmg);
        return dmg == maxDmg;
    }

    public int getColor(ItemStack itemStack, int tint) {
        if (tint == 0) {
            int color = -10795217;
            Species species = this.getSpecies(itemStack);
            if (itemStack.has(DTRegistries.STAFF_HANDLE_COLOR_DATA_COMPONENT.get())) {
                color = ((DyedItemColor)itemStack.getOrDefault(DTRegistries.STAFF_HANDLE_COLOR_DATA_COMPONENT.get(), (Object)new DyedItemColor(color, false))).rgb();
            } else if (species.isValid()) {
                color = species.getFamily().woodBarkColor;
            }
            return color;
        }
        if (tint == 1) {
            int color = -16711681;
            if (itemStack.has(DTRegistries.STAFF_CRYSTAL_COLOR_DATA_COMPONENT.get())) {
                color = ((DyedItemColor)itemStack.get(DTRegistries.STAFF_CRYSTAL_COLOR_DATA_COMPONENT.get())).rgb();
            }
            return color;
        }
        return -1;
    }

    public Staff setColor(ItemStack itemStack, int color) {
        itemStack.set(DTRegistries.STAFF_CRYSTAL_COLOR_DATA_COMPONENT.get(), (Object)new DyedItemColor(color, false));
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        if (itemStack.has(DTRegistries.JOCODE_DATA_COMPONENT.get())) {
            String newCode = (String)itemStack.get(DTRegistries.JOCODE_DATA_COMPONENT.get());
            if (newCode != null) {
                code = newCode;
            }
        } else {
            itemStack.set(DTRegistries.JOCODE_DATA_COMPONENT.get(), (Object)code);
        }
        return code;
    }

    public String getRootsCode(ItemStack itemStack) {
        String newCode;
        if (itemStack.has(DTRegistries.ROOTS_JOCODE_DATA_COMPONENT.get()) && (newCode = (String)itemStack.get(DTRegistries.ROOTS_JOCODE_DATA_COMPONENT.get())) != null) {
            return newCode;
        }
        return "";
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.dynamictrees.species", (Object[])new Object[]{this.getSpecies(stack).getTextComponent()}));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.dynamictrees.jo_code", (Object[])new Object[]{new JoCode(this.getCode(stack)).getTextComponent()}));
        String rootsCode = this.getRootsCode(stack);
        if (!rootsCode.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.dynamictrees.roots_jo_code", (Object[])new Object[]{new RootsJoCode(rootsCode).getTextComponent()}));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

