/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.entry;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class ItemBySpeciesLootPoolEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<ItemBySpeciesLootPoolEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)BuiltInRegistries.ITEM.holderByNameCodec()).fieldOf("name_by_species").forGetter(c -> c.items)).and(ItemBySpeciesLootPoolEntry.singletonFields((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, ItemBySpeciesLootPoolEntry::new));
    private final Map<ResourceLocation, Holder<Item>> items;

    public ItemBySpeciesLootPoolEntry(Map<ResourceLocation, Holder<Item>> items, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType getType() {
        return DTRegistries.ITEM_BY_SPECIES.get();
    }

    protected void createItemStack(Consumer<ItemStack> stackConsumer, LootContext context) {
        Species species = (Species)context.getParamOrNull(DTLootContextParams.SPECIES);
        assert (species != null);
        Holder<Item> itemHolder = this.items.get(species.getRegistryName());
        Item item = itemHolder == null ? Items.AIR : (Item)itemHolder.value();
        stackConsumer.accept(new ItemStack((ItemLike)item));
    }
}

