/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.model.ModelHelper;
import com.dtteam.dynamictrees.model.baked.BasicBranchBlockBakedModel;
import com.dtteam.dynamictrees.model.modeldata.ModelConnections;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ThickBranchBlockBakedModel
extends BasicBranchBlockBakedModel {
    private final BakedModel[] trunksBark = new BakedModel[16];
    private final BakedModel[] trunksTopBark = new BakedModel[16];
    private final BakedModel[] trunksTopRings = new BakedModel[16];
    private final BakedModel[] trunksBotRings = new BakedModel[16];

    public ThickBranchBlockBakedModel(IGeometryBakingContext customData, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, ResourceLocation thickRingsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        super(customData, barkTextureLocation, ringsTextureLocation, spriteGetter);
        this.initThickModels(spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, thickRingsTextureLocation)));
    }

    public void initThickModels(TextureAtlasSprite thickRingsTexture) {
        for (int i = 0; i < 16; ++i) {
            int radius = i + 8 + 1;
            this.trunksBark[i] = this.bakeTrunkBark(radius, this.barkTexture, true);
            this.trunksTopBark[i] = this.bakeTrunkBark(radius, this.barkTexture, false);
            this.trunksTopRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.UP);
            this.trunksBotRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.DOWN);
        }
    }

    private boolean isTextureNull(@Nullable TextureAtlasSprite sprite) {
        return sprite == null || sprite.equals(ModelHelper.getTexture(ResourceLocation.parse((String)"")));
    }

    public BakedModel bakeTrunkBark(int radius, TextureAtlasSprite bark, boolean side) {
        Direction[] directionArray;
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, bark);
        AABB wholeVolume = new AABB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        if (side) {
            directionArray = CoordUtils.HORIZONTALS;
        } else {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.UP;
            directionArray = directionArray2;
            directionArray2[1] = Direction.DOWN;
        }
        Direction[] run = directionArray;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
            offsets.add(surround.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (CoordUtils.Surround surround : run) {
            Vec3i dirVector = surround.getNormal();
            for (Vec3i offset : offsets) {
                if (surround.getAxis() != Direction.Axis.Y) {
                    Vec3 vec3 = new Vec3((double)dirVector.getX(), (double)dirVector.getY(), (double)dirVector.getZ());
                    Vec3 vec32 = new Vec3((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
                    if (!(vec3.add(vec32).lengthSqr() > 2.25)) continue;
                }
                Vec3 scaledOffset = new Vec3((double)(offset.getX() * 16), (double)(offset.getY() * 16), (double)(offset.getZ() * 16));
                AABB partBoundary = new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).move(scaledOffset).intersect(wholeVolume);
                Vector3f[] limits = ModelHelper.AABBLimits(partBoundary);
                EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelHelper.modUV(ModelHelper.getUVs(partBoundary, (Direction)surround)), this.getFaceAngle(Direction.Axis.Y, (Direction)surround));
                mapFacesIn.put(surround, new BlockElementFace(null, -1, null, uvface));
                BlockElement part = new BlockElement(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.addCulledFace((Direction)surround, ModelHelper.makeBakedQuad(part, (BlockElementFace)part.faces.get((Object)surround), bark, (Direction)surround, BlockModelRotation.X0_Y0));
            }
        }
        return builder.build();
    }

    public BakedModel bakeTrunkRings(int radius, TextureAtlasSprite ring, Direction face) {
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, ring);
        AABB wholeVolume = new AABB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        int wholeVolumeWidth = 48;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            offsets.add(dir.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (Vec3i offset : offsets) {
            Vec3 scaledOffset = new Vec3((double)(offset.getX() * 16), (double)(offset.getY() * 16), (double)(offset.getZ() * 16));
            AABB partBoundary = new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).move(scaledOffset).intersect(wholeVolume);
            Vector3f posFrom = new Vector3f((float)partBoundary.minX, (float)partBoundary.minY, (float)partBoundary.minZ);
            Vector3f posTo = new Vector3f((float)partBoundary.maxX, (float)partBoundary.maxY, (float)partBoundary.maxZ);
            EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
            float[] uvs = ThickBranchBlockBakedModel.getUvs(face, partBoundary, wholeVolumeWidth);
            BlockFaceUV uvFace = new BlockFaceUV(uvs, this.getFaceAngle(Direction.Axis.Y, face));
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvFace));
            BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)part.faces.get(face), ring, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    private static float @NotNull [] getUvs(Direction face, AABB partBoundary, int wholeVolumeWidth) {
        float textureOffsetX = -16.0f;
        float textureOffsetZ = -16.0f;
        float minX = (float)((partBoundary.minX - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
        float maxX = (float)((partBoundary.maxX - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
        float minZ = (float)((partBoundary.minZ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
        float maxZ = (float)((partBoundary.maxZ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
        if (face == Direction.DOWN) {
            minZ = (float)((partBoundary.maxZ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            maxZ = (float)((partBoundary.minZ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
        }
        return new float[]{minX, minZ, maxX, maxZ};
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        int coreRadius = this.getRadius(state);
        if (coreRadius <= 8) {
            return super.getQuads(state, null, rand, extraData, renderType);
        }
        coreRadius = Mth.clamp((int)coreRadius, (int)9, (int)24);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(30);
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        int twigRadius = 1;
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            Family family = connectionsData.getFamily();
            if (family.isValid()) {
                twigRadius = family.getPrimaryThickness();
            }
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != 0 ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            return quads;
        }
        if (forceRingDir != null) {
            connections[forceRingDir.get3DDataValue()] = 0;
            quads.addAll(this.trunksBotRings[coreRadius - 9].getQuads(state, forceRingDir, rand, extraData, renderType));
        }
        boolean branchesAround = connections[2] + connections[3] + connections[4] + connections[5] != 0;
        for (Direction face : Direction.values()) {
            quads.addAll(this.trunksBark[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
            if (face != Direction.UP && face != Direction.DOWN) continue;
            if (connections[face.get3DDataValue()] < twigRadius && !branchesAround) {
                quads.addAll(this.trunksTopRings[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
                continue;
            }
            if (connections[face.get3DDataValue()] >= coreRadius) continue;
            quads.addAll(this.trunksTopBark[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
        }
        return quads;
    }
}

