/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;

public class ConiferTopperGenFeature
extends GenFeature {
    public static final ConfigurationProperty<LeavesProperties> LEAVES_PROPERTIES = ConfigurationProperty.property("leaves_properties", LeavesProperties.class);

    public ConiferTopperGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(LEAVES_PROPERTIES);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(LEAVES_PROPERTIES, LeavesProperties.NULL);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.endPoints().isEmpty()) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos highest = Collections.max(context.endPoints(), Comparator.comparingInt(Vec3i::getY));
        LeavesProperties leavesProperties = configuration.get(LEAVES_PROPERTIES).elseIfInvalid(context.species().getLeavesProperties());
        level.setBlock(highest.above(1), leavesProperties.getDynamicLeavesState(4), 3);
        level.setBlock(highest.above(2), leavesProperties.getDynamicLeavesState(3), 3);
        level.setBlock(highest.above(3), leavesProperties.getDynamicLeavesState(1), 3);
        return true;
    }
}

