/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PodzolGenFeature
extends GenFeature {
    public PodzolGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!Services.CONFIG.getBoolConfig("generatePodzol").booleanValue()) {
            return false;
        }
        LevelAccessor level = context.level();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(level, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        RandomSource random = context.random();
        BlockPos pos = endPoints.get(random.nextInt(endPoints.size()));
        int x = pos.getX() + random.nextInt(5) - 2;
        int z = pos.getZ() + random.nextInt(5) - 2;
        int darkThreshold = 4;
        for (int i = 0; i < 32; ++i) {
            BlockState state;
            Block block;
            BlockPos offPos = new BlockPos(x, pos.getY() - 1 - i, z);
            if (level.isEmptyBlock(offPos) || (block = (state = level.getBlockState(offPos)).getBlock()) instanceof BranchBlock || block instanceof MushroomBlock || block instanceof LeavesBlock) continue;
            if (block instanceof FlowerBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock) {
                if (level.getBrightness(LightLayer.SKY, offPos) > 4) continue;
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (!SoilHelper.isSoilAcceptable(state, SoilHelper.getSoilFlags("dirt_like"))) break;
            if (level.getBrightness(LightLayer.SKY, offPos.above()) <= 4) {
                level.setBlock(offPos, Blocks.PODZOL.defaultBlockState(), 3);
                break;
            }
            PodzolGenFeature.spreadPodzol(level, pos);
            break;
        }
        return true;
    }

    public static void spreadPodzol(LevelAccessor level, BlockPos pos) {
        int podzolish = 0;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos deltaPos = pos.relative(dir);
            Block testBlock = level.getBlockState(deltaPos).getBlock();
            podzolish += testBlock == Blocks.PODZOL ? 1 : 0;
            if ((podzolish += testBlock instanceof SoilBlock ? 1 : 0) < 3) continue;
            level.setBlock(pos, Blocks.PODZOL.defaultBlockState(), 3);
            break;
        }
    }
}

