/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.growthlogic;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.configuration.ConfigurableRegistry;
import com.dtteam.dynamictrees.api.configuration.ConfigurableRegistryEntry;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.MathUtils;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class GrowthLogicKit
extends ConfigurableRegistryEntry<GrowthLogicKit, GrowthLogicKitConfiguration> {
    public static final ConfigurationProperty<Integer> HEIGHT_VARIATION = ConfigurationProperty.integer("height_variation");
    public static final GrowthLogicKit DEFAULT = new GrowthLogicKit(DynamicTrees.NULL){

        @Override
        public GrowthLogicKitConfiguration getDefaultConfiguration() {
            return (GrowthLogicKitConfiguration)this.defaultConfiguration;
        }
    };
    public static final ConfigurableRegistry<GrowthLogicKit, GrowthLogicKitConfiguration> REGISTRY = new ConfigurableRegistry<GrowthLogicKit, GrowthLogicKitConfiguration>(GrowthLogicKit.class, DEFAULT, GrowthLogicKitConfiguration.TEMPLATES);

    public GrowthLogicKit(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return new GrowthLogicKitConfiguration(this);
    }

    @Override
    protected void registerProperties() {
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        if (context.signal().numSteps + 1 <= configuration.getLowestBranchHeight(new PositionalSpeciesContext(context.level(), context.signal().rootPos, context.species())) && !context.signal().getSpecies().getLeavesProperties().canGrowOnGround()) {
            return context.signal().defaultDir;
        }
        int[] probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(context.level(), context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(context.level().getBlockState(context.pos())), new int[6]));
        int choice = MathUtils.selectRandomFromDistribution(context.signal().rand, probMap);
        return Direction.values()[choice != -1 ? choice : 1];
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.getOpposite();
        Direction defaultDir = context.signal().defaultDir;
        probMap[defaultDir.ordinal()] = context.signal().dir != defaultDir.getOpposite() ? context.species().getUpProbability() : 0;
        int n = context.signal().dir.ordinal();
        probMap[n] = probMap[n] + context.species().getProbabilityForCurrentDir();
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = context.pos().relative(dir);
            BlockState deltaBlockState = context.level().getBlockState(deltaPos);
            int n2 = dir.get3DDataValue();
            probMap[n2] = probMap[n2] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getSignalEnergy();
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getLowestBranchHeight();
    }

    public static GrowthLogicKit findGrowthLogicKit(String name) {
        return GrowthLogicKit.findGrowthLogicKit(ResourceLocationUtils.parseDTLocation(name));
    }

    public static GrowthLogicKit findGrowthLogicKit(ResourceLocation name) {
        return (GrowthLogicKit)REGISTRY.get(name);
    }
}

