/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.nodemapper;

import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class InflatorNode
implements NodeInspector {
    private float radius;
    private BlockPos last;
    private BlockPos highestTrunkBlock;
    private int maxRadius;
    Species species;
    SimpleVoxmap leafMap;

    public InflatorNode(Species species, SimpleVoxmap leafMap) {
        this(species, leafMap, species.getMaxBranchRadius());
    }

    public InflatorNode(Species species, SimpleVoxmap leafMap, int maxRadius) {
        this.species = species;
        this.leafMap = leafMap;
        this.last = BlockPos.ZERO;
        this.highestTrunkBlock = null;
        this.maxRadius = Math.min(maxRadius, species.getMaxBranchRadius());
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null) {
            this.radius = this.species.getFamily().getPrimaryThickness();
            if (this.highestTrunkBlock == null && !TreeHelper.isBranch(level.getBlockState(pos.above()))) {
                this.highestTrunkBlock = pos;
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (Direction dir : Direction.values()) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.relative(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                BlockState deltaBlockState = level.getBlockState(dPos);
                TreePart treepart = TreeHelper.getTreePart(deltaBlockState);
                if (!branch.isSameTree(treepart)) continue;
                int branchRadius = treepart.getRadius(deltaBlockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                }
            } else {
                float secondaryThickness;
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                if (this.radius > (float)this.maxRadius) {
                    this.radius = this.maxRadius;
                }
                if (this.highestTrunkBlock != null) {
                    boolean isInTrunk;
                    int blockRadius = 8;
                    boolean bl = isInTrunk = pos.getX() == this.highestTrunkBlock.getX() && pos.getY() <= this.highestTrunkBlock.getY() && pos.getZ() == this.highestTrunkBlock.getZ();
                    if (this.radius > (float)blockRadius && !isInTrunk) {
                        this.radius = blockRadius;
                    }
                }
                if (this.radius < (secondaryThickness = (float)this.species.getFamily().getSecondaryThickness())) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(level, pos, (int)Math.floor(this.radius), null);
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)32);
                }
            }
            this.last = pos;
        } else {
            SoilBlock rooty = TreeHelper.getRooty(state);
            if (rooty != null) {
                rooty.updateRadius(level, state, pos, 2, false);
            }
        }
        return false;
    }
}

