/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import com.dtteam.dynamictrees.systems.season.SeasonProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class SeasonContext {
    private final SeasonProvider provider;
    private final SeasonGrowthCalculator calculator;
    private float temperateGrowthFactor;
    private float tropicalGrowthFactor;
    private float temperateSeedDropFactor;
    private float tropicalSeedDropFactor;
    private float temperateFruitProductionFactor;
    private float tropicalFruitProductionFactor;
    private Float seasonValue;
    private final Float temperatePeakFruitProductionSeasonValue;
    private final Float tropicalPeakFruitProductionSeasonValue;
    private long methodTicks = 0L;

    public SeasonContext(SeasonProvider provider, SeasonGrowthCalculator calculator) {
        this.provider = provider;
        this.calculator = calculator;
        this.temperatePeakFruitProductionSeasonValue = calculator.getPeakFruitProductionSeasonValue(ClimateZoneType.TEMPERATE);
        this.tropicalPeakFruitProductionSeasonValue = calculator.getPeakFruitProductionSeasonValue(ClimateZoneType.TROPICAL);
    }

    public void updateTick(Level world, long dayTime) {
        if (this.methodTicks % 20L == 0L) {
            this.provider.updateTick(world, dayTime);
            this.seasonValue = this.provider.getSeasonValue(world, BlockPos.ZERO);
            this.temperateGrowthFactor = this.calculator.calcGrowthRate(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalGrowthFactor = this.calculator.calcGrowthRate(this.seasonValue, ClimateZoneType.TROPICAL);
            this.temperateSeedDropFactor = this.calculator.calcSeedDropRate(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalSeedDropFactor = this.calculator.calcSeedDropRate(this.seasonValue, ClimateZoneType.TROPICAL);
            this.temperateFruitProductionFactor = this.calculator.calcFruitProduction(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalFruitProductionFactor = this.calculator.calcFruitProduction(this.seasonValue, ClimateZoneType.TROPICAL);
        }
        ++this.methodTicks;
    }

    public SeasonProvider getSeasonProvider() {
        return this.provider;
    }

    public SeasonGrowthCalculator getCalculator() {
        return this.calculator;
    }

    public float getTemperateGrowthFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateGrowthFactor : this.calculator.calcGrowthRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalGrowthFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalGrowthFactor : this.calculator.calcGrowthRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }

    public float getTemperateSeedDropFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateSeedDropFactor : this.calculator.calcSeedDropRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalSeedDropFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalSeedDropFactor : this.calculator.calcSeedDropRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }

    public float getTemperateFruitProductionFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateFruitProductionFactor : this.calculator.calcFruitProduction(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalFruitProductionFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalFruitProductionFactor : this.calculator.calcFruitProduction(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }

    public Float getTemperatePeakFruitProductionSeasonValue(float offset) {
        return this.temperatePeakFruitProductionSeasonValue == null ? null : Float.valueOf(this.temperatePeakFruitProductionSeasonValue.floatValue() + offset);
    }

    public Float getTropicalPeakFruitProductionSeasonValue(float offset) {
        return this.tropicalPeakFruitProductionSeasonValue == null ? null : Float.valueOf(this.tropicalPeakFruitProductionSeasonValue.floatValue() + offset);
    }
}

