/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.SeasonManager;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.NormalSeasonManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class SeasonHelper {
    public static final float SPRING = 0.0f;
    public static final float SUMMER = 1.0f;
    public static final float AUTUMN = 2.0f;
    public static final float WINTER = 3.0f;
    public static final float DRY = 1.0f;
    public static final float WET = 3.0f;
    private static SeasonManager seasonManager = NormalSeasonManager.NULL.get();

    public static SeasonManager getSeasonManager() {
        return seasonManager;
    }

    public static void setSeasonManager(SeasonManager manager) {
        seasonManager = manager;
    }

    public static void updateTick(Level level, long dayTime) {
        seasonManager.updateTick(level, dayTime);
    }

    public static float globalSeasonalGrowthFactor(LevelContext levelContext, BlockPos rootPos) {
        return SeasonHelper.globalSeasonalGrowthFactor(levelContext, rootPos, 0.0f);
    }

    public static float globalSeasonalGrowthFactor(LevelContext levelContext, BlockPos rootPos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalGrowthFactor") != false ? seasonManager.getGrowthFactor(levelContext.level(), rootPos, offset) : 1.0f;
    }

    public static float globalSeasonalSeedDropFactor(LevelContext levelContext, BlockPos pos) {
        return SeasonHelper.globalSeasonalSeedDropFactor(levelContext, pos, 0.0f);
    }

    public static float globalSeasonalSeedDropFactor(LevelContext levelContext, BlockPos pos, float offset) {
        return Services.CONFIG.getBoolConfig("enableSeasonalSeedDropFactor") != false ? seasonManager.getSeedDropFactor(levelContext.level(), pos, offset) : 1.0f;
    }

    public static float globalSeasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos, boolean getAsScan) {
        return SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, pos, 0.0f, getAsScan);
    }

    public static float globalSeasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos, float offset, boolean getAsScan) {
        return Services.CONFIG.getBoolConfig("enableSeasonalFruitProductionFactor") != false ? seasonManager.getFruitProductionFactor(levelContext.level(), pos, offset, getAsScan) : 1.0f;
    }

    public static Float getSeasonValue(LevelContext levelContext, BlockPos pos) {
        return seasonManager.getSeasonValue(levelContext.level(), pos);
    }

    public static boolean isTropical(Level level, BlockPos pos) {
        return seasonManager.isTropical(level, pos);
    }

    public static boolean isSeasonBetween(Float testValue, float SeasonA, float SeasonB) {
        testValue = Float.valueOf(testValue.floatValue() % 4.0f);
        if ((SeasonA %= 4.0f) <= (SeasonB %= 4.0f)) {
            return testValue.floatValue() > SeasonA && testValue.floatValue() < SeasonB;
        }
        return testValue.floatValue() < SeasonB || testValue.floatValue() > SeasonA;
    }

    public static boolean shouldSnowMelt(Level level, BlockPos pos) {
        return seasonManager.shouldSnowMelt(level, pos);
    }
}

