/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.featurecancellation;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class FungusFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> fungusFeatureConfigClass;

    public FungusFeatureCanceller(ResourceLocation registryName, Class<T> fungusFeatureConfigClass) {
        super(registryName);
        this.fungusFeatureConfigClass = fungusFeatureConfigClass;
    }

    @Override
    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)configuredFeature.feature());
        return featureRegistryName != null && this.fungusFeatureConfigClass.isInstance(configuredFeature.config()) && featureCancellations.shouldCancelNamespace(featureRegistryName.getNamespace());
    }
}

