/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.PalmLeavesLoaderBuilder;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class PalmLeavesStateGenerator
implements Generator<DTBlockStateProvider, LeavesProperties> {
    public static final Generator.DependencyKey<DynamicLeavesBlock> LEAVES = new Generator.DependencyKey("leaves");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LEAVES = new Generator.DependencyKey("primitive_leaves");

    @Override
    public void generate(DTBlockStateProvider provider, LeavesProperties input, Generator.Dependencies dependencies) {
        ResourceLocation defaultFrondsTexture = provider.block(ResourceLocationUtils.suffix(input.getRegistryName(), "_frond"));
        ResourceLocation defaultCoreTexture = provider.block(ResourceLocationUtils.suffix(input.getRegistryName(), "_base"));
        PalmLeavesProperties palmInput = (PalmLeavesProperties)input;
        PalmLeavesLoaderBuilder frondBuilder = (PalmLeavesLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getFrondsModelName())).customLoader(palmInput.getFrondsLoaderConstructor());
        palmInput.addFrondTextures(frondBuilder::texture, defaultFrondsTexture);
        BlockModelBuilder coreTopBuilder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getCoreTopModelName())).parent((ModelFile)provider.models().getExistingFile(palmInput.getCoreTopSmartModelLocation()));
        palmInput.addFrondTextures((arg_0, arg_1) -> ((BlockModelBuilder)coreTopBuilder).texture(arg_0, arg_1), defaultFrondsTexture);
        BlockModelBuilder coreBottomBuilder = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(palmInput.getCoreBottomModelName())).parent((ModelFile)provider.models().getExistingFile(palmInput.getCoreBottomSmartModelLocation()));
        palmInput.addCoreTextures((arg_0, arg_1) -> ((BlockModelBuilder)coreBottomBuilder).texture(arg_0, arg_1), defaultCoreTexture);
        ModelFile.ExistingModelFile blockModel = provider.models().getExistingFile(palmInput.getModelPath("leaves").orElse(provider.block(ForgeRegistries.BLOCKS.getKey((Object)dependencies.get(PRIMITIVE_LEAVES)))));
        IntegerProperty distance = PalmLeavesProperties.DynamicPalmLeavesBlock.f_54418_;
        IntegerProperty direction = PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION;
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder((Block)dependencies.get(LEAVES)).part().modelFile((ModelFile)frondBuilder.end()).addModel()).condition((Property)distance, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)coreTopBuilder).addModel()).condition((Property)distance, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)coreBottomBuilder).addModel()).condition((Property)distance, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)blockModel).addModel()).useOr().nestedGroup().condition((Property)direction, (Comparable[])new Integer[]{0}).condition((Property)distance, (Comparable[])new Integer[]{1, 2}).end().nestedGroup().condition((Property)distance, (Comparable[])new Integer[]{5, 6, 7}).end().end();
    }

    @Override
    public Generator.Dependencies gatherDependencies(LeavesProperties input) {
        return new Generator.Dependencies().append(LEAVES, input.getDynamicLeavesBlock()).append(PRIMITIVE_LEAVES, input.getPrimitiveLeavesBlock());
    }
}

