/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.GrowableBlock;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class PodBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
GrowableBlock {
    protected final Pod pod;

    public PodBlock(BlockBehaviour.Properties properties, Pod pod) {
        super(properties);
        this.pod = pod;
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.f_49792_ = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
        if (this.pod != null) {
            builder.m_61104_(new Property[]{this.pod.getAgeProperty()});
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.pod.getBlockShape(this.getFacing(state), this.getAge(state));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.doTick(state, (Level)level, pos, random);
    }

    public void doTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop((LevelAccessor)level, pos, state);
            return;
        }
        int age = this.getAge(state);
        Float season = SeasonHelper.getSeasonValue(LevelContext.create((LevelAccessor)level), pos);
        if (season != null) {
            if (this.pod.isOutOfSeason(LevelContext.create((LevelAccessor)level), pos)) {
                this.outOfSeason(level, pos);
                return;
            }
            if (age == 0 && this.pod.isInFlowerHoldPeriod((LevelAccessor)level, pos, season)) {
                return;
            }
        }
        if (age < this.pod.getMaxAge()) {
            this.tryGrow(state, level, pos, random, age, season);
        } else {
            this.tickMature(level, pos, state);
        }
    }

    private void outOfSeason(Level level, BlockPos pos) {
        level.m_46961_(pos, false);
    }

    private void tryGrow(BlockState state, Level level, BlockPos pos, RandomSource random, int age, @Nullable Float season) {
        boolean doGrow = random.m_188501_() < this.getGrowthChance(level, pos);
        boolean eventGrow = ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            this.setAge(level, pos, state, age + 1);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private float getGrowthChance(Level level, BlockPos pos) {
        return this.pod.getGrowthChance();
    }

    public void tickMature(Level level, BlockPos pos, BlockState state) {
        this.pod.performMatureAction(new GrowableBlock.Info((LevelAccessor)level, pos, state));
    }

    @Override
    public void performMatureAction(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isSupported((LevelReader)level, pos, state)) {
            this.drop((LevelAccessor)level, pos, state);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.isSupported(level, pos, state);
    }

    @Override
    public boolean isSupported(LevelReader level, BlockPos pos, BlockState state) {
        BlockState branchState = level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)));
        return TreeHelper.getBranchOpt(branchState).map(branch -> this.pod.isValidRadius(branch.getRadius(branchState))).orElse(false);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder level) {
        ResourceLocation resourcelocation = this.m_60589_();
        if (resourcelocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootParams lootParams = level.m_287286_(LootContextParams.f_81461_, (Object)pState).m_287235_(LootContextParamSets.f_81421_);
        LootTable loottable = lootParams.m_287182_().m_7654_().m_278653_().m_278676_(resourcelocation);
        if (loottable == LootTable.f_79105_ && pState.m_61138_((Property)this.pod.getAgeProperty()) && ((Integer)pState.m_61143_((Property)this.pod.getAgeProperty())).intValue() == this.pod.getMaxAge()) {
            return Collections.singletonList(this.pod.getItemStack());
        }
        return loottable.m_287195_(lootParams);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.pod.getItemStack();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getAge(state) >= this.pod.getMaxAge()) {
            this.drop((LevelAccessor)level, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.pod.canBoneMeal() && this.getAge(state) < this.pod.getMaxAge();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        int newAge = Math.min(age + 1, this.pod.getMaxAge());
        if (newAge != age) {
            this.setAge((Level)level, pos, state, newAge);
        }
    }

    private Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)f_54117_);
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.pod.getAgeProperty());
    }

    public float getAgeAsPercentage(BlockState state) {
        return (float)this.getAge(state) * 100.0f / (float)this.getMaxAge();
    }

    public int getMaxAge() {
        return this.pod.getMaxAge();
    }

    private void setAge(Level level, BlockPos pos, BlockState state, int newAge) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)this.pod.getAgeProperty(), (Comparable)Integer.valueOf(0));
        BlockPos pos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)context.m_43725_(), pos)) continue;
            return state;
        }
        return null;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

