/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.block.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.ferreusveritas.dynamictrees.client.TextureUtils;
import com.ferreusveritas.dynamictrees.entity.render.FallingTreeRenderer;
import com.ferreusveritas.dynamictrees.entity.render.LingeringEffectorRenderer;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="dynamictrees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTClient {
    public static void setup() {
        DTClient.registerRenderLayers();
        DTClient.registerColorHandlers();
        LeavesProperties.postInitClient();
        BlockColorMultipliers.cleanUp();
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(DTRegistries.FALLING_TREE.get(), FallingTreeRenderer::new);
        event.registerEntityRenderer(DTRegistries.LINGERING_EFFECTOR.get(), LingeringEffectorRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void discoverWoodColors() {
        Function bakedTextureGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        for (Family family : Species.REGISTRY.getAll().stream().map(Species::getFamily).distinct().collect(Collectors.toList())) {
            family.woodRingColor = 16773550;
            family.woodBarkColor = 11774329;
            if (family == Family.NULL_FAMILY) continue;
            family.getPrimitiveLog().ifPresent(branch -> {
                BlockState state = branch.m_49966_();
                family.woodRingColor = DTClient.getFaceColor(state, Direction.DOWN, bakedTextureGetter);
                family.woodBarkColor = DTClient.getFaceColor(state, Direction.NORTH, bakedTextureGetter);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getFaceColor(BlockState state, Direction face, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        List quads = model.getQuads(state, face, RandomSource.m_216327_(), ModelData.EMPTY, null);
        if (quads.isEmpty()) {
            quads = model.getQuads(state, null, RandomSource.m_216327_(), ModelData.EMPTY, null);
        }
        if (quads.isEmpty()) {
            LogManager.getLogger().warn("Could not get color of " + String.valueOf(face) + " side for " + String.valueOf(state.m_60734_()) + "! Branch needs to be handled manually!");
            return 0;
        }
        TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
        TextureUtils.PixelBuffer pixelBuffer = new TextureUtils.PixelBuffer(sprite);
        int u = pixelBuffer.w / 16;
        TextureUtils.PixelBuffer center = new TextureUtils.PixelBuffer(u * 8, u * 8);
        pixelBuffer.blit(center, u * -8, u * -8);
        return center.averageColor();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerColorHandlersEvent(RegisterColorHandlersEvent event) {
        DTClient.registerJsonColorMultipliers();
    }

    private static void registerJsonColorMultipliers() {
        BlockColorMultipliers.register("birch", (state, level, pos, tintIndex) -> FoliageColor.m_46112_());
        BlockColorMultipliers.register("spruce", (state, level, pos, tintIndex) -> FoliageColor.m_46106_());
    }

    private static boolean isValidPos(BlockGetter level, BlockPos pos) {
        return level != null && pos != null;
    }

    private static void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DTRegistries.POTTED_SAPLING.get()), (RenderType)RenderType.m_110457_());
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof DynamicSaplingBlock || block instanceof RootyBlock || block instanceof FruitBlock || block instanceof PodBlock).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
    }

    private static void registerColorHandlers() {
        int white = -1;
        int magenta = 0xFF00FF;
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        for (RootyBlock roots : SoilHelper.getRootyBlocksList()) {
            blockColors.m_92589_((state, level, pos, tintIndex) -> roots.colorMultiplier(blockColors, state, level, pos, tintIndex), new Block[]{roots});
        }
        ModelHelper.regColorHandler((Block)DTRegistries.POTTED_SAPLING.get(), (state, level, pos, tintIndex) -> DTClient.isValidPos((BlockGetter)level, pos) && state.m_60734_() instanceof PottedSaplingBlock ? DTRegistries.POTTED_SAPLING.get().getSpecies((BlockGetter)level, pos).saplingColorMultiplier(state, level, pos, tintIndex) : -1);
        ModelHelper.regColorHandler(DTRegistries.DENDRO_POTION.get(), DTRegistries.DENDRO_POTION.get()::getColor);
        ModelHelper.regColorHandler(DTRegistries.STAFF.get(), DTRegistries.STAFF.get()::getColor);
        for (Species species : Species.REGISTRY) {
            if (!species.getSapling().isPresent()) continue;
            ModelHelper.regColorHandler(species.getSapling().get(), (state, level, pos, tintIndex) -> DTClient.isValidPos((BlockGetter)level, pos) ? species.saplingColorMultiplier(state, level, pos, tintIndex) : -1);
        }
        for (DynamicLeavesBlock leaves : LeavesProperties.REGISTRY.getAll().stream().filter(lp -> lp.getDynamicLeavesBlock().isPresent()).map(lp -> lp.getDynamicLeavesBlock().get()).collect(Collectors.toSet())) {
            ModelHelper.regColorHandler((Block)leaves, (state, level, pos, tintIndex) -> {
                LeavesProperties properties = ((DynamicLeavesBlock)state.m_60734_()).getProperties(state);
                return TreeHelper.isLeaves(state.m_60734_()) ? properties.foliageColorMultiplier(state, level, pos) : 0xFF00FF;
            });
        }
    }

    private static void addDustParticle(Level level, double fx, double fy, double fz, double mx, double my, double mz, BlockState blockState, float r, float g, float b) {
        if (level.f_46443_) {
            Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), fx, fy, fz, mx, my, mz);
            assert (particle != null);
            particle.m_107253_(r, g, b);
        }
    }

    public static void spawnParticles(Level level, SimpleParticleType particleType, BlockPos pos, int numParticles, RandomSource random) {
        DTClient.spawnParticles((LevelAccessor)level, particleType, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), numParticles, random);
    }

    public static void spawnParticles(LevelAccessor level, SimpleParticleType particleType, int x, int y, int z, int numParticles, RandomSource random) {
        for (int i1 = 0; i1 < numParticles; ++i1) {
            double mx = random.m_188583_() * 0.02;
            double my = random.m_188583_() * 0.02;
            double mz = random.m_188583_() * 0.02;
            DTClient.spawnParticle(level, particleType, (float)x + random.m_188501_(), (double)y + (double)random.m_188501_(), (double)z + (double)random.m_188501_(), mx, my, mz);
        }
    }

    public static void spawnParticle(LevelAccessor level, SimpleParticleType particleType, double x, double y, double z, double mx, double my, double mz) {
        if (level.m_5776_()) {
            level.m_7106_((ParticleOptions)particleType, x, y, z, mx, my, mz);
        }
    }

    private static int getFoliageColor(LeavesProperties leavesProperties, Level level, BlockState blockState, BlockPos pos) {
        return leavesProperties.foliageColorMultiplier(blockState, (BlockAndTintGetter)level, pos);
    }

    public static void crushLeavesBlock(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        if (level.f_46443_) {
            RandomSource random = level.f_46441_;
            TreePart treePart = TreeHelper.getTreePart(blockState);
            if (treePart instanceof DynamicLeavesBlock) {
                DynamicLeavesBlock leaves = (DynamicLeavesBlock)treePart;
                LeavesProperties leavesProperties = leaves.getProperties(blockState);
                int color = DTClient.getFoliageColor(leavesProperties, level, blockState, pos);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                for (int dz = 0; dz < 8; ++dz) {
                    for (int dy = 0; dy < 8; ++dy) {
                        for (int dx = 0; dx < 8; ++dx) {
                            if (random.m_188503_(8) != 0) continue;
                            double fx = (double)pos.m_123341_() + (double)dx / 8.0;
                            double fy = (double)pos.m_123342_() + (double)dy / 8.0;
                            double fz = (double)pos.m_123343_() + (double)dz / 8.0;
                            DTClient.addDustParticle(level, fx, fy, fz, 0.0, (double)random.m_188501_() * entity.m_20184_().f_82480_, 0.0, blockState, r, g, b);
                        }
                    }
                }
            }
        }
    }
}

