/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostRotContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.IPlantable;

public class MushroomRotGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> ALTERNATE_MUSHROOM = ConfigurationProperty.block("alternate_mushroom");
    public static final ConfigurationProperty<Float> ALTERNATE_MUSHROOM_CHANCE = ConfigurationProperty.floatProperty("alternate_mushroom_chance");

    public MushroomRotGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM, ALTERNATE_MUSHROOM, ALTERNATE_MUSHROOM_CHANCE);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM, Blocks.f_50072_)).with(ALTERNATE_MUSHROOM, Blocks.f_50073_)).with(ALTERNATE_MUSHROOM_CHANCE, Float.valueOf(0.25f));
    }

    @Override
    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        Block mushroom;
        LevelAccessor level = context.level();
        BlockPos pos = context.pos();
        Block block = mushroom = configuration.get(ALTERNATE_MUSHROOM_CHANCE).floatValue() > context.random().m_188501_() ? configuration.get(MUSHROOM) : configuration.get(ALTERNATE_MUSHROOM);
        if (context.radius() <= 4 || !this.canSustainMushroom(level, pos, mushroom) || level.m_45517_(LightLayer.SKY, pos) >= 4) {
            return false;
        }
        level.m_7731_(pos, mushroom.m_49966_(), 3);
        return true;
    }

    private boolean canSustainMushroom(LevelAccessor level, BlockPos pos, Block block) {
        return block instanceof IPlantable && level.m_8055_(pos).canSustainPlant((BlockGetter)level, pos, Direction.UP, (IPlantable)block);
    }
}

