/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substance;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.FruitGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestSubstance
implements SubstanceEffect {
    private Species species = Species.NULL_SPECIES;
    private final int duration;
    private final int ticksPerParticlePulse;
    private final int ticksPerGrowthPulse;
    private final int growthPulses;
    private final int ticksPerSpawnAttempt;
    public final Set<BlockPos> fruitPositions = Sets.newHashSet();

    public HarvestSubstance() {
        this(1600, 12, 12, 1, 16);
    }

    public HarvestSubstance(int duration, int ticksPerParticlePulse, int ticksPerGrowthPulse, int growthPulses, int ticksPerSpawnAttempt) {
        this.duration = duration;
        this.ticksPerParticlePulse = ticksPerParticlePulse;
        this.ticksPerGrowthPulse = ticksPerGrowthPulse;
        this.growthPulses = growthPulses;
        this.ticksPerSpawnAttempt = ticksPerSpawnAttempt;
    }

    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        BlockState rootState = level.m_8055_(rootPos);
        RootyBlock rootyBlock = TreeHelper.getRooty(rootState);
        if (rootyBlock == null) {
            return false;
        }
        this.species = rootyBlock.getSpecies(rootState, (LevelAccessor)level, rootPos);
        if (!this.species.hasFruits()) {
            return false;
        }
        this.recalculateFruitPositions((LevelAccessor)level, rootPos, rootyBlock);
        return true;
    }

    private void recalculateFruitPositions(LevelAccessor level, BlockPos rootPos, RootyBlock rootyBlock) {
        this.fruitPositions.clear();
        FindEndsNode findEndsNode = new FindEndsNode();
        rootyBlock.startAnalysis(level, rootPos, new MapSignal(findEndsNode));
        findEndsNode.getEnds().forEach(endPos -> BlockPos.m_121990_((BlockPos)endPos.m_7918_(-3, -3, -3), (BlockPos)endPos.m_7918_(3, 3, 3)).forEach(pos -> {
            if (this.isCompatibleFruitBlock(level, (BlockPos)pos)) {
                this.fruitPositions.add(pos.m_7949_());
            }
        }));
    }

    private boolean isCompatibleFruitBlock(LevelAccessor level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        return this.isCompatibleFruitBlock(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatibleFruitBlock(Block block) {
        if (!(block instanceof FruitBlock)) return false;
        if (!this.species.getFruits().stream().map(Fruit::getBlock).anyMatch(block::equals)) return false;
        return true;
    }

    @Override
    public boolean update(Level level, BlockPos rootPos, int deltaTicks, int fertility) {
        if (deltaTicks > this.duration) {
            return false;
        }
        RootyBlock rootyBlock = TreeHelper.getRooty(level.m_8055_(rootPos));
        if (rootyBlock == null) {
            return false;
        }
        if (level.f_46443_) {
            if (deltaTicks % this.ticksPerParticlePulse == 0) {
                this.recalculateFruitPositions((LevelAccessor)level, rootPos, rootyBlock);
                this.fruitPositions.forEach(fruitPos -> DTClient.spawnParticles((LevelAccessor)level, ParticleTypes.f_123806_, fruitPos.m_123341_(), fruitPos.m_123342_(), fruitPos.m_123343_(), 3, level.m_213780_()));
            }
        } else {
            boolean spawnAttempt;
            boolean growPulse = deltaTicks % this.ticksPerGrowthPulse == 0;
            boolean bl = spawnAttempt = deltaTicks % this.ticksPerSpawnAttempt == 0;
            if (growPulse || spawnAttempt) {
                this.recalculateFruitPositions((LevelAccessor)level, rootPos, rootyBlock);
            }
            if (growPulse) {
                this.fruitPositions.removeIf(fruitPos -> {
                    BlockState state = level.m_8055_(fruitPos);
                    Block block = state.m_60734_();
                    if (!this.isCompatibleFruitBlock(block)) {
                        return true;
                    }
                    for (int i = 0; i < this.growthPulses; ++i) {
                        ((FruitBlock)block).doTick(state, level, (BlockPos)fruitPos, level.f_46441_);
                    }
                    return false;
                });
            }
            if (spawnAttempt) {
                this.species.getGenFeatures().stream().filter(configuration -> configuration.getGenFeature() instanceof FruitGenFeature).forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(level, rootPos, this.species, rootPos.m_121945_(rootyBlock.getTrunkDirection((BlockGetter)level, rootPos)), fertility, true)));
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "harvest";
    }

    @Override
    public boolean isLingering() {
        return true;
    }
}

