/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.configuration;

import com.dtteam.dynamictrees.api.configuration.Configurable;
import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.configuration.Properties;
import com.dtteam.dynamictrees.api.configuration.PropertiesAccessor;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Configuration<T extends Configuration<T, C>, C extends Configurable>
extends RegistryEntry<T> {
    protected final C configurable;
    protected final Properties properties = new Properties();

    public Configuration(C configurable) {
        this.configurable = configurable;
    }

    public <V> T with(ConfigurationProperty<V> property, @Nullable V value) {
        if (!this.configurable.isPropertyRegistered(property)) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)new IllegalArgumentException(), (String)("Tried to add unregistered property with identifier '" + property.getKey() + "' and type '" + String.valueOf(property.getType()) + "' configurable '" + String.valueOf(this.configurable) + "'."));
            crashReport.addCategory("Adding property to a gen feature.");
            throw new ReportedException(crashReport);
        }
        this.properties.put(property, value);
        return (T)this;
    }

    public T withAll(PropertiesAccessor properties) {
        properties.forEach(this::with);
        return (T)this;
    }

    public boolean has(ConfigurationProperty<?> property) {
        return this.properties.has(property);
    }

    @NotNull
    public <V> V get(ConfigurationProperty<V> property) {
        Optional<V> optionalProperty = this.getAsOptional(property);
        if (optionalProperty.isPresent()) {
            return optionalProperty.get();
        }
        CrashReport crashReport = CrashReport.forThrowable((Throwable)new IllegalStateException(), (String)("Property '" + property.getKey() + "' from '" + String.valueOf(this.configurable) + "' is Null."));
        crashReport.addCategory("Getting property from a configuration");
        throw new ReportedException(crashReport);
    }

    public <V> Optional<V> getAsOptional(ConfigurationProperty<V> property) {
        if (!this.has(property)) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)new IllegalStateException(), (String)("Tried to obtain property '" + property.getKey() + "' from '" + String.valueOf(this.configurable) + "' that did not exist."));
            crashReport.addCategory("Getting property from a configuration");
            throw new ReportedException(crashReport);
        }
        return Optional.ofNullable(this.properties.get(property));
    }

    public <V> V getOrInvalidDefault(ConfigurationProperty<V> property, Predicate<V> validator, V invalidDefault) {
        return this.getAsOptional(property).filter(validator).orElse(invalidDefault);
    }

    public abstract T copy();

    public C getConfigurable() {
        return this.configurable;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{configurable=" + String.valueOf(this.configurable) + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

