/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.pod.OffsetablePodBlock;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.cell.MetadataCell;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class BasicBranchBlock
extends BranchBlock
implements SimpleWaterloggedBlock {
    protected static final IntegerProperty RADIUS = IntegerProperty.create((String)"radius", (int)1, (int)8);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final BlockState[] branchStates;
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    private final int maxRadiusForWaterLogging = 7;

    public BasicBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        this(name, properties, RADIUS, 8);
    }

    public BasicBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties, IntegerProperty radiusProperty, int maxRadius) {
        super(name, properties);
        this.branchStates = this.createBranchStates(radiusProperty, maxRadius);
    }

    public BlockState[] createBranchStates(IntegerProperty radiusProperty, int maxRadius) {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)radiusProperty, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockState[] branchStates = new BlockState[maxRadius + 1];
        branchStates[0] = Blocks.AIR.defaultBlockState();
        for (int radius = 1; radius <= maxRadius; ++radius) {
            branchStates[radius] = (BlockState)this.defaultBlockState().setValue((Property)radiusProperty, (Comparable)Integer.valueOf(radius));
        }
        return branchStates;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RADIUS}).add(new Property[]{WATERLOGGED});
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return this.isSameTree(branch) ? BasicBranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public boolean canFall() {
        return true;
    }

    @Override
    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        int neigh = 0;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.relative(dir);
            BlockState deltaBlockState = level.getBlockState(deltaPos);
            if (BasicBranchBlock.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (BlockGetter)level, this, deltaPos, dir, radius)) < 1 || BasicBranchBlock.getLeavesSupport(neigh) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(level, pos, neigh & 0xF, radius, fertility, rand, rapid, fertility > 0);
        if (rapid && didRot) {
            for (Direction dir : Direction.values()) {
                BlockPos neighPos = pos.relative(dir);
                BlockState neighState = level.getBlockState(neighPos);
                if (neighState.getBlock() != this) continue;
                this.checkForRot(level, neighPos, species, fertility, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.getRadius(state) > 7) {
            return false;
        }
        return super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        int radius = this.getRadius(level.getBlockState(pos));
        double hardness = (double)this.getFamily().getPrimitiveLog().orElse(Blocks.AIR).defaultBlockState().getDestroySpeed(level, pos) * Services.CONFIG.getDoubleConfig("treeHardnessMultiplier") * (double)(radius * radius) / 64.0 * 8.0;
        return (float)Math.min(hardness, Services.CONFIG.getDoubleConfig("maxTreeHardness"));
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        int radius = this.getRadius(level.getBlockState(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammability;
    }

    public BasicBranchBlock setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BasicBranchBlock setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        Family thisTree = this.getFamily();
        if (leavesProperties.getFamily() == thisTree) {
            int radiusAndMeta = thisTree.getRadiusForCellKit(level, pos, state, dir, this);
            int radius = MetadataCell.getRadius(radiusAndMeta);
            int metadata = MetadataCell.getMeta(radiusAndMeta);
            return leavesProperties.getCellKit().getCellForBranch(radius, metadata);
        }
        return CellNull.NULL_CELL;
    }

    @Override
    public int getRadius(BlockState state) {
        return this.isSameTree(state) && state.hasProperty((Property)RADIUS) ? (Integer)state.getValue((Property)RADIUS) : 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        boolean replacingWater = level.getBlockState(pos).getFluidState() == Fluids.WATER.getSource(false);
        boolean setWaterlogged = replacingWater && radius <= 7;
        level.setBlock(pos, (BlockState)this.getStateForRadius(radius).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public BlockState getStateForRadius(int radius) {
        return this.branchStates[Mth.clamp((int)radius, (int)1, (int)this.getMaxRadius())];
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(state) + 2 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GrowSignal growIntoAir(Level level, BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        DynamicLeavesBlock leaves = species.getLeavesBlock().orElse(null);
        if (leaves != null) {
            if (fromRadius != this.getFamily().getPrimaryThickness()) return leaves.branchOut(level, pos, signal);
            signal.success = 0 != leaves.growLeavesIfLocationIsSuitable((LevelAccessor)level, species.getLeavesProperties(), pos, 0);
            return signal;
        } else {
            if (BasicBranchBlock.isNextToBranch(level, pos, signal.dir.getOpposite())) {
                signal.success = false;
                return signal;
            }
            this.setRadius((LevelAccessor)level, pos, this.getFamily().getPrimaryThickness(), null);
            signal.radius = this.getFamily().getSecondaryThickness();
            signal.success = true;
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        if (!signal.step()) {
            return signal;
        }
        BlockState currBlockState = level.getBlockState(pos);
        Species species = signal.getSpecies();
        boolean inTrunk = signal.isInTrunk();
        Direction originDir = signal.dir.getOpposite();
        Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(level, pos, species, this, signal));
        signal.doTurn(targetDir);
        BlockPos deltaPos = pos.relative(targetDir);
        BlockState deltaState = level.getBlockState(deltaPos);
        Direction[] treepart = TreeHelper.getTreePart(deltaState);
        if (treepart != TreeHelper.NULL_TREE_PART) {
            signal = treepart.growSignal(level, deltaPos, signal);
        } else if (level.isEmptyBlock(deltaPos) || deltaState.getBlock() instanceof TrunkShellBlock) {
            signal = this.growIntoAir(level, deltaPos, signal, this.getRadius(currBlockState));
        }
        float areaAccum = signal.radius * signal.radius;
        boolean theresPods = false;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir)) continue;
            BlockPos deltaPos2 = pos.relative(dir);
            BlockState blockState = level.getBlockState(deltaPos2);
            TreePart treepart2 = TreeHelper.getTreePart(blockState);
            if (this.isSameTree(treepart2)) {
                int branchRadius = treepart2.getRadius(blockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (!(blockState.getBlock() instanceof OffsetablePodBlock)) continue;
            theresPods = true;
        }
        if (!signal.choked) {
            int flags;
            int maxRadius = inTrunk ? species.getMaxBranchRadius() : Math.min(species.getMaxBranchRadius(), 8);
            signal.radius = Mth.clamp((float)((float)Math.sqrt(areaAccum) + species.getTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
            int targetRadius = (int)Math.floor(signal.radius);
            int setRad = this.setRadius((LevelAccessor)level, pos, targetRadius, originDir, flags = theresPods ? 3 : 2);
            if (setRad < targetRadius) {
                signal.choked = true;
            }
        }
        return signal;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return Services.CONFIG.getBoolConfig("enableBranchClimbing") != false && entity instanceof Player && this.getFamily().branchIsLadder() && (!state.hasProperty((Property)WATERLOGGED) || (Boolean)state.getValue((Property)WATERLOGGED) == false);
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(state);
    }

    protected int getMaxSignalDepth() {
        return this.getFamily().getMaxSignalDepth();
    }

    @Override
    public MapSignal analyse(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, level, pos, fromDir);
            for (Direction dir : Direction.values()) {
                BlockPos deltaPos;
                BlockState deltaState;
                TreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = level.getBlockState(deltaPos = pos.relative(dir)))).shouldAnalyse(deltaState, (BlockGetter)level, deltaPos)) continue;
                signal = treePart.analyse(deltaState, level, deltaPos, dir.getOpposite(), signal);
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, level, pos, fromDir);
        } else {
            Block block;
            BlockState state = level.getBlockState(pos);
            if (signal.destroyLoopedNodes && (block = state.getBlock()) instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)block;
                branch.breakDeliberate(level, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    @Override
    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean waterlogged = state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        return waterlogged ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }
}

