/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.branch;

import com.dtteam.dynamictrees.block.BlockWithDynamicHardness;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.Musable;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictrees.utility.NullUtils;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class TrunkShellBlock
extends BlockWithDynamicHardness
implements SimpleWaterloggedBlock {
    public static final EnumProperty<CoordUtils.Surround> CORE_DIR = EnumProperty.create((String)"coredir", CoordUtils.Surround.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TrunkShellBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().pushReaction(PushReaction.BLOCK).sound(SoundType.WOOD).explosionResistance(3.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CORE_DIR}).add(new Property[]{WATERLOGGED});
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ShellMuse muse = this.getMuseUnchecked((BlockGetter)level, state, pos);
        if (!this.isValid(muse)) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
            } else {
                level.removeBlock(pos, false);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return NullUtils.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> Services.INTERACTION.blockDestroyByPlayer(muse.state, level, muse.pos, player, willHarvest, level.getFluidState(pos)), false);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return NullUtils.applyIfNonnull(this.getMuse(level, state, pos), muse -> Float.valueOf(muse.state.getDestroyProgress(player, level, muse.pos)), Float.valueOf(0.0f)).floatValue();
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return state;
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        return NullUtils.applyIfNonnull(this.getMuse(level, pos), muse -> Float.valueOf(((BlockWithDynamicHardness)muse.state.getBlock()).getHardness(state, level, muse.pos)), Float.valueOf(super.getHardness(state, level, pos))).floatValue();
    }

    protected SoundType getSoundType(BlockState state) {
        return SoundType.WOOD;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        BlockPos clickedPos;
        Level level = useContext.getLevel();
        if (this.museDoesNotExist((BlockGetter)level, state, clickedPos = useContext.getClickedPos())) {
            this.scheduleUpdateTick((BlockGetter)level, clickedPos);
            return false;
        }
        return false;
    }

    public CoordUtils.Surround getMuseDir(BlockState state, BlockPos pos) {
        return (CoordUtils.Surround)((Object)state.getValue(CORE_DIR));
    }

    public boolean museDoesNotExist(BlockGetter level, BlockState state, BlockPos pos) {
        BlockPos musePos = pos.offset(this.getMuseDir(state, pos).getOffset());
        return ChunkTreeHelper.getStateSafe(level, musePos) == null;
    }

    @Nullable
    public ShellMuse getMuseUnchecked(BlockGetter level, BlockState state, BlockPos pos) {
        return this.getMuseUnchecked(level, state, pos, pos);
    }

    @Nullable
    public ShellMuse getMuseUnchecked(BlockGetter level, BlockState state, BlockPos pos, BlockPos originalPos) {
        CoordUtils.Surround museDir = this.getMuseDir(state, pos);
        BlockPos musePos = pos.offset(museDir.getOffset());
        BlockState museState = ChunkTreeHelper.getStateSafe(level, musePos);
        if (museState == null) {
            return null;
        }
        Block block = museState.getBlock();
        if (block instanceof Musable && ((Musable)block).isMusable(level, museState, musePos)) {
            return new ShellMuse(museState, musePos, museDir, musePos.subtract((Vec3i)originalPos));
        }
        if (block instanceof TrunkShellBlock) {
            Vec3i offset = ((TrunkShellBlock)block).getMuseDir(museState, musePos).getOffset();
            Vec3 vec3 = new Vec3((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
            Vec3 vec32 = new Vec3((double)museDir.getOffset().getX(), (double)museDir.getOffset().getY(), (double)museDir.getOffset().getZ());
            if (vec3.add(vec32).lengthSqr() > 2.25) {
                return ((TrunkShellBlock)block).getMuseUnchecked(level, museState, musePos, originalPos);
            }
        }
        return null;
    }

    @Nullable
    public ShellMuse getMuse(BlockGetter level, BlockPos pos) {
        return this.getMuse(level, level.getBlockState(pos), pos);
    }

    @Nullable
    public ShellMuse getMuse(BlockGetter level, BlockState state, BlockPos pos) {
        ShellMuse muse = this.getMuseUnchecked(level, state, pos);
        if (!this.isValid(muse)) {
            this.scheduleUpdateTick(level, pos);
        }
        return muse;
    }

    protected boolean isValid(@Nullable ShellMuse muse) {
        return muse != null && muse.getRadius() > 8;
    }

    public void scheduleUpdateTick(BlockGetter level, BlockPos pos) {
        if (!(level instanceof LevelAccessor)) {
            return;
        }
        ((LevelAccessor)level).getBlockTicks().schedule(new ScheduledTick((Object)this, pos.immutable(), 0L, TickPriority.HIGH, 0L));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean p_220069_6_) {
        this.scheduleUpdateTick((BlockGetter)level, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return NullUtils.applyIfNonnull(this.getMuse(level, state, pos), muse -> Shapes.create((AABB)muse.state.getShape(level, muse.pos).bounds().move(muse.museOffset)), Shapes.empty());
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return NullUtils.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.getBlock().getCloneItemStack(level, muse.pos, muse.state), ItemStack.EMPTY);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        NullUtils.consumeIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> muse.state.onExplosionHit(level, muse.pos, explosion, dropConsumer));
    }

    @Nullable
    protected CoordUtils.Surround findDetachedMuse(Level level, BlockPos pos) {
        for (CoordUtils.Surround s : CoordUtils.Surround.values()) {
            BlockState state = level.getBlockState(pos.offset(s.getOffset()));
            if (!(state.getBlock() instanceof Musable)) continue;
            return s;
        }
        return null;
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockState newState = level.getBlockState(pos);
        if (newState.getBlock() != Blocks.AIR) {
            return;
        }
        NullUtils.consumeIfNonnull(this.findDetachedMuse((Level)level, pos), surround -> level.setBlock(pos, (BlockState)this.defaultBlockState().setValue(CORE_DIR, (Comparable)((Object)surround)), 1));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return NullUtils.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> {
            BlockHitResult newHit = hitResult.withPosition(muse.pos);
            return muse.state.useItemOn(stack, level, player, hand, newHit);
        }, ItemInteractionResult.FAIL);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return NullUtils.applyIfNonnull(this.getMuse((BlockGetter)level, state, pos), muse -> {
            BlockHitResult newHit = hitResult.withPosition(muse.pos);
            return muse.state.useWithoutItem(level, player, newHit);
        }, InteractionResult.FAIL);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public boolean isFullBlockShell(BlockGetter level, BlockPos pos) {
        return this.isFullBlockShell(this.getMuse(level, pos));
    }

    public boolean isFullBlockShell(@Nullable ShellMuse muse) {
        return muse != null && this.isFullBlockShell(muse.getRadius());
    }

    public boolean isFullBlockShell(int radius) {
        return (radius - 8) % 16 == 0;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.getFluidTicks().schedule(new ScheduledTick((Object)Fluids.WATER, currentPos, (long)Fluids.WATER.getTickDelay((LevelReader)level), 0L));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.isFullBlockShell(level, pos)) {
            return false;
        }
        return super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    public boolean isWaterLogged(BlockState state) {
        return state.hasProperty((Property)WATERLOGGED) && (Boolean)state.getValue((Property)WATERLOGGED) != false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public record ShellMuse(BlockState state, BlockPos pos, CoordUtils.Surround dir, BlockPos museOffset) {
        public int getRadius() {
            Block block = this.state.getBlock();
            return block instanceof BranchBlock ? ((BranchBlock)block).getRadius(this.state) : 0;
        }
    }
}

