/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.soil;

import com.dtteam.dynamictrees.api.cell.Cell;
import com.dtteam.dynamictrees.api.cell.CellNull;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.BlockWithDynamicHardness;
import com.dtteam.dynamictrees.block.branch.BasicRootsBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilBlockDecayer;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.block.soil.SpeciesBlockEntity;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.tree.ChunkTreeHelper;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SoilBlock
extends BlockWithDynamicHardness
implements TreePart,
EntityBlock,
BonemealableBlock {
    public static SoilBlockDecayer soilBlockDecayer = null;
    public static final IntegerProperty FERTILITY = IntegerProperty.create((String)"fertility", (int)0, (int)15);
    public static final BooleanProperty IS_VARIANT = BooleanProperty.create((String)"is_variant");
    private final SoilProperties properties;

    public SoilBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
        super(blockProperties.randomTicks().pushReaction(PushReaction.BLOCK));
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FERTILITY, (Comparable)Integer.valueOf(0))).setValue((Property)IS_VARIANT, (Comparable)Boolean.valueOf(false)));
    }

    public SoilProperties getSoilProperties() {
        return this.properties;
    }

    public Block getPrimitiveSoilBlock() {
        return this.getSoilProperties().getPrimitiveSoilBlock();
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.getSoilProperties().getPrimitiveSoilState(currentSoilState);
    }

    public float getSpeedFactor() {
        return this.getPrimitiveSoilBlock().getSpeedFactor();
    }

    public float getJumpFactor() {
        return this.getPrimitiveSoilBlock().getJumpFactor();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.getPrimitiveSoilBlock() == Blocks.AIR) {
            return super.getShape(state, level, pos, context);
        }
        return this.getPrimitiveSoilBlock().defaultBlockState().getShape(level, pos, context);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.getPrimitiveSoilBlock() == Blocks.AIR) {
            return super.getCollisionShape(state, level, pos, context);
        }
        return this.getPrimitiveSoilBlock().defaultBlockState().getCollisionShape(level, pos, context);
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.getPrimitiveSoilBlock() == Blocks.AIR) {
            return super.getVisualShape(state, level, pos, context);
        }
        return this.getPrimitiveSoilBlock().defaultBlockState().getVisualShape(level, pos, context);
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getPrimitiveSoilBlock() == Blocks.AIR) {
            return super.getBlockSupportShape(state, level, pos);
        }
        return this.getPrimitiveSoilBlock().defaultBlockState().getBlockSupportShape(level, pos);
    }

    protected SoundType getSoundType(BlockState state) {
        return this.getPrimitiveSoilBlock().defaultBlockState().getSoundType();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilBlock().defaultBlockState().propagatesSkylightDown(level, pos);
    }

    public float getFriction() {
        return this.getPrimitiveSoilBlock().getFriction();
    }

    public float getExplosionResistance() {
        return this.getPrimitiveSoilBlock().getExplosionResistance();
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilBlock().defaultBlockState().getLightBlock(level, pos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getPrimitiveSoilState(state).getDrops(builder);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getPrimitiveSoilBlock().getCloneItemStack(level, pos, this.getPrimitiveSoilState(state));
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        return (float)((double)this.getPrimitiveSoilState(state).getDestroySpeed(level, pos) * Services.CONFIG.getDoubleConfig("rootyBlockHardnessMultiplier"));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FERTILITY}).add(new Property[]{IS_VARIANT});
    }

    public BlockState GetStateFromIndex(int index) {
        return this.defaultBlockState();
    }

    public int getStateIndex(BlockState state) {
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)IS_VARIANT)).booleanValue()) {
            return new SpeciesBlockEntity(pPos, pState);
        }
        return null;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.getValue((Property)IS_VARIANT);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        double growthMultiplier = Services.CONFIG.getDoubleConfig("treeGrowthMultiplier");
        if ((double)random.nextFloat() > growthMultiplier) {
            return;
        }
        int attempts = (int)Math.ceil(growthMultiplier);
        for (int i = 0; i < attempts; ++i) {
            this.updateTree(state, (Level)level, pos, random, true);
        }
    }

    public Direction getTrunkDirection(BlockGetter access, BlockPos rootPos) {
        return Direction.UP;
    }

    public void updateTree(BlockState rootyState, Level level, BlockPos soilPos, RandomSource random, boolean natural) {
        if (ChunkTreeHelper.isSurroundedByLoadedChunks(level, soilPos)) {
            BlockPos treePos;
            TreePart treeBase;
            boolean viable = false;
            Species species = this.getSpecies(rootyState, (LevelAccessor)level, soilPos);
            if (species.isValid() && (treeBase = TreeHelper.getTreePart(level.getBlockState(treePos = soilPos.relative(this.getTrunkDirection((BlockGetter)level, soilPos))))) != TreeHelper.NULL_TREE_PART) {
                viable = species.update(level, this, soilPos, this.getFertility(rootyState, (BlockGetter)level, soilPos), treeBase, treePos, random, natural);
            }
            if (!viable) {
                this.doDecay(level, soilPos, rootyState);
            }
        }
    }

    public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilState(state);
    }

    public void doDecay(Level level, BlockPos rootPos, BlockState rootyState) {
        level.setBlock(rootPos, this.getDecayBlockState(rootyState, (BlockGetter)level, rootPos), 3);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getFertility(blockState, (BlockGetter)level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.getFamily(state, (BlockGetter)level, pos).onTreeActivated(new Family.TreeActivationContext(level, TreeHelper.findRootNode(level, pos), pos, state, player, hand, stack, hitResult)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
    }

    public void destroyTree(Level level, BlockPos rootPos) {
        this.destroyTree(level, rootPos, null);
    }

    public void destroyTree(Level level, BlockPos rootPos, @Nullable Player player) {
        this.destroyTree(level, rootPos, player, this.getTrunkDirection((BlockGetter)level, rootPos));
        this.destroyTree(level, rootPos, player, this.getTrunkDirection((BlockGetter)level, rootPos).getOpposite());
    }

    public void destroyTree(Level level, BlockPos rootPos, @Nullable Player player, Direction dir) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.getBlockState(rootPos.offset(dir.getNormal())));
        if (branch.isPresent()) {
            BranchDestructionData destroyData = branch.get().destroyBranchFromNode(level, rootPos.offset(dir.getNormal()), dir.getOpposite(), true, (LivingEntity)player);
            FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.getSpecies(state, (LevelAccessor)level, pos).soilDestroyAction(level, pos, state, player)) {
            this.spawnDestroyParticles(level, player, pos, state);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return false;
        }
        return level.isClientSide() ? level.setBlock(pos, fluid.createLegacyBlock(), 11) : level.removeBlock(pos, false);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.destroyTree(level, pos);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(level, pos, explosion);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.destroyTree(level, pos, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    public int updateRadius(LevelAccessor level, BlockState state, BlockPos pos, int flags, boolean force) {
        return this.getRadius(state);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            return this.getSpecies(blockState, (LevelAccessor)level, blockPos).canBoneMealTree();
        }
        return false;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Species species = this.getSpecies(pState, (LevelAccessor)pLevel, pPos);
        if (species.isValid()) {
            species.applySubstance((Level)pLevel, pPos, pPos, null, null, new ItemStack((ItemLike)Items.BONE_MEAL));
        }
    }

    public int getFertility(BlockState blockState, BlockGetter blockAccess, BlockPos pos) {
        return (Integer)blockState.getValue((Property)FERTILITY);
    }

    public void setFertility(Level level, BlockPos rootPos, int fertility) {
        BlockState currentState = level.getBlockState(rootPos);
        Species species = this.getSpecies(currentState, (LevelAccessor)level, rootPos);
        level.setBlock(rootPos, (BlockState)currentState.setValue((Property)FERTILITY, (Comparable)Integer.valueOf(Mth.clamp((int)fertility, (int)0, (int)15))), 3);
        level.updateNeighborsAt(rootPos, (Block)this);
        this.setSpecies(level, rootPos, species);
    }

    public boolean fertilize(Level level, BlockPos pos, int amount) {
        int fertility = this.getFertility(level.getBlockState(pos), (BlockGetter)level, pos);
        if (fertility == 0 && amount < 0 || fertility == 15 && amount > 0) {
            return false;
        }
        this.setFertility(level, pos, fertility + amount);
        return true;
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesTree) {
        return CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadius(BlockState state) {
        return 8;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return 0;
    }

    public MapSignal startAnalysis(LevelAccessor level, BlockPos rootPos, MapSignal signal) {
        Direction dir = this.getTrunkDirection((BlockGetter)level, rootPos);
        BlockPos treePos = rootPos.relative(dir);
        BlockState treeState = level.getBlockState(treePos);
        TreeHelper.getTreePart(treeState).analyse(treeState, level, treePos, null, signal);
        return signal;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        signal.run(state, level, pos, fromDir);
        if (signal.root == null) {
            signal.root = pos;
        } else {
            signal.multiroot = true;
        }
        signal.foundRoot = true;
        return signal;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (neighborPos.equals((Object)pos.relative(this.getTrunkDirection((BlockGetter)level, pos)))) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.is((Block)this)) {
            return;
        }
        if (this.getMainTrunk((BlockGetter)level, pos) == null) {
            this.doDecay((Level)level, pos, state);
        }
        super.tick(state, level, pos, random);
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        Direction supportDir = branch instanceof BasicRootsBlock ? Direction.UP : Direction.DOWN;
        return dir == supportDir ? BranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos rootPos) {
        BranchBlock branchBlock = this.getMainTrunk(level, rootPos);
        return branchBlock != null ? branchBlock.getFamily() : Family.NULL_FAMILY;
    }

    @Nullable
    protected BranchBlock getMainTrunk(BlockGetter level, BlockPos soilPos) {
        BlockPos pos = soilPos.relative(this.getTrunkDirection(level, soilPos));
        BlockState trunkState = level.getBlockState(pos);
        return TreeHelper.getBranch(trunkState);
    }

    @Nullable
    protected SpeciesBlockEntity getTileEntitySpecies(LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        return blockEntity instanceof SpeciesBlockEntity ? (SpeciesBlockEntity)blockEntity : null;
    }

    public Species getSpecies(BlockState state, LevelAccessor level, BlockPos soilPos) {
        Species species;
        Family family = this.getFamily(state, (BlockGetter)level, soilPos);
        if (!family.isValid()) {
            return Species.NULL_SPECIES;
        }
        SpeciesBlockEntity rootyDirtTE = this.getTileEntitySpecies(level, soilPos);
        if (rootyDirtTE != null && (species = rootyDirtTE.getSpecies()).getFamily() == family) {
            return rootyDirtTE.getSpecies();
        }
        return family.getSpeciesForLocation(level, soilPos.relative(this.getTrunkDirection((BlockGetter)level, soilPos)));
    }

    public void setSpecies(Level level, BlockPos rootPos, Species species) {
        SpeciesBlockEntity rootyDirtTE = this.getTileEntitySpecies((LevelAccessor)level, rootPos);
        if (rootyDirtTE != null) {
            rootyDirtTE.setSpecies(species);
        }
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.ROOT;
    }

    @Override
    public final boolean isRootNode() {
        return true;
    }

    public int colorMultiplier(BlockColors blockColors, BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        int white = -1;
        if (tintIndex == this.getSoilProperties().foliageTintIndex) {
            return blockColors.getColor(this.getPrimitiveSoilState(state), level, pos, tintIndex);
        }
        if (tintIndex == this.getSoilProperties().rootsTintIndex) {
            return state.getBlock() instanceof SoilBlock ? this.rootColor(state, (BlockGetter)level, pos) : -1;
        }
        return -1;
    }

    public boolean getColorFromBark() {
        return false;
    }

    public int rootColor(BlockState state, BlockGetter blockAccess, BlockPos pos) {
        return this.getFamily(state, blockAccess, pos).getRootColor(state, this.getColorFromBark());
    }

    public boolean fallWithTree(BlockState state, Level level, BlockPos pos, boolean hasRoots) {
        return false;
    }
}

