/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.provider;

import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.client.ThickBranchRingsSource;
import com.dtteam.dynamictrees.tree.family.Family;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SpriteSourceProvider;

public class DTSpriteSourceProvider
extends SpriteSourceProvider {
    private final String modId;
    private final List<Registry<Family>> registries;

    public DTSpriteSourceProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper, Registry<?> ... registries) {
        super(output, lookupProvider, modId, existingFileHelper);
        this.modId = modId;
        this.registries = ImmutableList.copyOf(this.castToFamilyRegistries(registries));
    }

    private List<Registry<Family>> castToFamilyRegistries(Registry<?> ... registries) {
        return Arrays.stream(registries).filter(registry -> Family.class.isAssignableFrom(registry.getType())).map(registry -> registry).toList();
    }

    protected void gather() {
        SpriteSourceProvider.SourceList blockSourceList = this.atlas(BLOCKS_ATLAS);
        this.registries.forEach(registry -> registry.dataGenerationStream(this.modId).forEach(family -> this.gatherForFamily((Family)family, blockSourceList)));
    }

    private void gatherForFamily(Family family, SpriteSourceProvider.SourceList atlasList) {
        family.topBranchTextureLocations().forEach(location -> atlasList.addSource((SpriteSource)new ThickBranchRingsSource((ResourceLocation)location)));
    }
}

