/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.applier;

import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.deserialization.deserializer.Deserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class MapPropertyApplier<T, V, I>
extends PropertyApplier<T, Map<String, V>, I> {
    private final Function<I, JsonObject> jsonObjectDeserializer;
    private final LazyValue<Deserializer<JsonElement, V>> valueDeserializer;

    public MapPropertyApplier(String key, Class<T> objectClass, Applier<T, Map<String, V>> applier, Function<I, JsonObject> jsonObjectDeserializer, LazyValue<Deserializer<JsonElement, V>> valueDeserializer) {
        super(key, objectClass, applier);
        this.jsonObjectDeserializer = jsonObjectDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(T object, I input, Applier<T, Map<String, V>> applier) {
        HashMap values = new HashMap();
        this.jsonObjectDeserializer.apply(input).entrySet().forEach(entry -> this.valueDeserializer.get().deserialize((JsonElement)entry.getValue()).ifSuccessOrElse(v -> values.put((String)entry.getKey(), v), error -> LogManager.getLogger().error(error), warning -> LogManager.getLogger().warn(warning)));
        return applier.apply(object, values);
    }

    public static <T, V> MapPropertyApplier<T, V, JsonElement> json(String key, Class<T> objectClass, Class<V> valueClass, Applier<T, Map<String, V>> applier) {
        return new MapPropertyApplier<T, V, JsonElement>(key, objectClass, applier, element -> (JsonObject)JsonDeserializers.JSON_OBJECT.deserialize(element).get(), LazyValue.supplied(() -> JsonDeserializers.getOrThrow(valueClass)));
    }
}

