/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.loot.condition;

import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.tree.species.Species;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class SpeciesMatches
implements LootItemCondition {
    public static final MapCodec<SpeciesMatches> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(c -> c.regex)).apply((Applicative)instance, SpeciesMatches::new));
    private final String regex;

    public SpeciesMatches(String regex) {
        this.regex = regex;
    }

    public LootItemConditionType getType() {
        return DTRegistries.SPECIES_MATCHES.get();
    }

    public boolean test(LootContext context) {
        Species species = (Species)context.getParamOrNull(DTLootContextParams.SPECIES);
        assert (species != null);
        return String.valueOf(species.getRegistryName()).matches(this.regex);
    }

    public static LootItemCondition.Builder speciesMatches(String regex) {
        return () -> new SpeciesMatches(regex);
    }
}

