/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.season;

import com.dtteam.dynamictrees.api.season.ClimateZoneType;
import com.dtteam.dynamictrees.api.season.SeasonGrowthCalculator;
import net.minecraft.util.Mth;

public class ActiveSeasonGrowthCalculator
implements SeasonGrowthCalculator {
    protected float clippedsineWave(float seasonValue, float qPhase, float amplitude, float bias) {
        return Mth.clamp((float)((float)Math.sin((double)(seasonValue / 2.0f) * Math.PI + 0.7853981633974483 * (double)qPhase) * amplitude + bias), (float)0.0f, (float)1.0f);
    }

    @Override
    public float calcGrowthRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedsineWave(seasonValue.floatValue(), 7.0f, 0.8f, 1.0f);
            case ClimateZoneType.TROPICAL -> this.clippedsineWave(seasonValue.floatValue(), 2.0f, 0.31f, 0.9f);
            default -> 1.0f;
        };
    }

    @Override
    public float calcSeedDropRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedsineWave(seasonValue.floatValue(), 5.0f, 1.5f, -0.25f);
            case ClimateZoneType.TROPICAL -> this.clippedsineWave(seasonValue.floatValue(), 7.0f, 0.31f, 0.9f);
            default -> 1.0f;
        };
    }

    @Override
    public float calcFruitProduction(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> this.clippedsineWave(seasonValue.floatValue(), 7.0f, 1.0f, 1.0f);
            case ClimateZoneType.TROPICAL -> this.clippedsineWave(seasonValue.floatValue(), 1.0f, 0.31f, 0.9f);
            default -> 1.0f;
        };
    }

    @Override
    public Float getPeakFruitProductionSeasonValue(ClimateZoneType type) {
        return switch (type) {
            case ClimateZoneType.TEMPERATE -> Float.valueOf(1.5f);
            case ClimateZoneType.TROPICAL -> Float.valueOf(0.5f);
            default -> null;
        };
    }
}

