/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.species;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.network.BranchDestructionData;
import com.dtteam.dynamictrees.api.network.MapSignal;
import com.dtteam.dynamictrees.api.network.NodeInspector;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.substance.Emptiable;
import com.dtteam.dynamictrees.api.substance.SubstanceEffect;
import com.dtteam.dynamictrees.api.substance.SubstanceEffectProvider;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.CommonVoxelShapes;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.fruit.Fruit;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.pod.Pod;
import com.dtteam.dynamictrees.block.sapling.DynamicSaplingBlock;
import com.dtteam.dynamictrees.block.sapling.PottedSaplingBlock;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.block.soil.SpeciesBlockEntity;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.DTLootTableBuilder;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.data.tags.DTItemTags;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.entity.LingeringEffectorEntity;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.item.Seed;
import com.dtteam.dynamictrees.loot.DTLootContextParams;
import com.dtteam.dynamictrees.loot.DTLootParameterSets;
import com.dtteam.dynamictrees.model.FallingTreeEntityModel;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.registry.DTRegistries;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.SeedSaplingRecipe;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostRotContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.systems.nodemapper.DiseaseNode;
import com.dtteam.dynamictrees.systems.nodemapper.FindEndsNode;
import com.dtteam.dynamictrees.systems.nodemapper.InflatorNode;
import com.dtteam.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.dtteam.dynamictrees.systems.nodemapper.ShrinkerNode;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.systems.substance.FertilizeSubstance;
import com.dtteam.dynamictrees.systems.substance.GrowthSubstance;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.treepack.Resettable;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.IDTBiomeHolderSet;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.JoCodeRegistry;
import com.dtteam.dynamictrees.worldgen.RootsJoCode;
import com.dtteam.dynamictrees.worldgen.feature.DynamicTreeFeature;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Species
extends RegistryEntry<Species>
implements Resettable<Species> {
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.BlockState, Species>>> blockStateGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.ItemModel, Species>>> itemModelGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.Language, Species>>> languageGenerators = new HashMap();
    public static final Species NULL_SPECIES = new Species(){

        @Override
        public Optional<Seed> getSeed() {
            return Optional.empty();
        }

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
            return false;
        }

        @Override
        public boolean generate(DynamicTreeGenerationContext context) {
            return false;
        }

        @Override
        public float biomeSuitability(Level level, BlockPos pos) {
            return 0.0f;
        }

        @Override
        public Species setSeed(Supplier<Seed> seedSup) {
            return this;
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return ItemStack.EMPTY;
        }

        @Override
        public Component getTextComponent() {
            return this.formatComponent((Component)Component.translatable((String)"gui.none"), ChatFormatting.DARK_RED);
        }

        @Override
        public boolean update(Level level, SoilBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean rapid) {
            return false;
        }
    };
    public static final TypedRegistry.EntryType<Species> TYPE = Species.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)Species::new));
    public static final Codec<Species> CODEC = ResourceLocation.CODEC.comapFlatMap(Species::read, RegistryEntry::getRegistryName);
    public static final TypedRegistry<Species> REGISTRY = new TypedRegistry<Species>(Species.class, NULL_SPECIES, TYPE);
    protected Family family = Family.NULL_FAMILY;
    protected GrowthLogicKitConfiguration logicKit = GrowthLogicKitConfiguration.getDefault();
    protected float tapering = 0.3f;
    protected int upProbability = 2;
    protected int lowestBranchHeight = 3;
    protected float signalEnergy = 16.0f;
    protected float growthRate = 1.0f;
    protected SoilProperties forceSoil;
    protected int soilLongevity = 8;
    protected int soilTypeFlags = 0;
    protected int worldGenSoilTypeFlags = 0;
    protected int maxBranchRadius = 8;
    protected final List<Block> acceptableBlocksForGrowth = Lists.newArrayList();
    protected LeavesProperties leavesProperties = LeavesProperties.NULL;
    private final List<LeavesProperties> validLeaves = new LinkedList<LeavesProperties>();
    protected Supplier<Seed> seed;
    protected Boolean dropSeeds = null;
    protected Supplier<DynamicSaplingBlock> saplingBlock;
    protected Boolean tintSapling = true;
    protected Map<TagKey<Biome>, Float> envFactors = new HashMap<TagKey<Biome>, Float>();
    protected IDTBiomeHolderSet perfectBiomes = Services.MISC.newDTBiomeHolderSet();
    protected final List<GenFeatureConfiguration> genFeatures = new ArrayList<GenFeatureConfiguration>();
    protected CommonOverride commonOverride;
    private String unlocalizedName = "";
    private final Set<Fruit> fruits = new HashSet<Fruit>();
    private final Set<Pod> pods = new HashSet<Pod>();
    private Boolean shouldGenerateSeed;
    private String seedName = null;
    protected final Set<SeedSaplingRecipe> primitiveSaplingRecipe = new HashSet<SeedSaplingRecipe>();
    private Boolean shouldGenerateSapling;
    private boolean canSaplingGrowNaturally = true;
    private VoxelShape saplingShape = CommonVoxelShapes.SAPLING;
    private String saplingName = null;
    private SoundType saplingSound = SoundType.GRASS;
    private int allowedWaterHeightForWorldgen = 1;
    private boolean plantableOnFluid = false;
    private static final Direction[] upFirst = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private boolean doesRot = true;
    private boolean canBoneMealTree = true;
    protected float flowerSeasonHoldMin = 0.0f;
    protected float flowerSeasonHoldMax = 0.5f;
    @Nullable
    protected Float seasonalGrowthOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalSeedDropOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalFruitingOffset = Float.valueOf(0.0f);
    protected Boolean alwaysShowOnWaila = null;
    private Species megaSpecies = NULL_SPECIES;
    private Species preMegaSpecies = NULL_SPECIES;
    private boolean canCraftMegaSeed = true;
    protected float bigTreeSoundThreshold = 20.0f;
    private int worldGenLeafMapHeight = 32;
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, Species>> saplingStateGenerator = MutableLazyValue.supplied(blockStateGenerators.get(DynamicTrees.location("sapling")));
    protected final MutableLazyValue<Generator<DTDataProvider.ItemModel, Species>> seedItemModelGenerator = MutableLazyValue.supplied(itemModelGenerators.get(DynamicTrees.location("seed_item")));
    protected final MutableLazyValue<Generator<DTDataProvider.Language, Species>> speciesLangGenerator = MutableLazyValue.supplied(languageGenerators.get(DynamicTrees.location("species_lang")));
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, String> langOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String SAPLING = "sapling";
    public static final String SEED_PARENT = "seed_parent";
    public static final String SEED = "seed";
    private final LazyValue<ResourceLocation> voluntaryDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(this.getRegistryName(), "trees/voluntary/"));

    public static TypedRegistry.EntryType<Species> createDefaultType(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return TypedRegistry.newType(Species.createDefaultCodec(constructor));
    }

    public static Codec<Species> createDefaultCodec(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(TypedRegistry.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName), (App)Family.REGISTRY.getGetterCodec().fieldOf("family").forGetter(Species::getFamily), (App)LeavesProperties.REGISTRY.getGetterCodec().optionalFieldOf("leaves_properties", (Object)LeavesProperties.NULL).forGetter(Species::getLeavesProperties)).apply((Applicative)instance, constructor));
    }

    private static DataResult<Species> read(ResourceLocation name) {
        Species species = (Species)REGISTRY.get(name);
        return species == null ? DataResult.error(() -> "Species not found: " + String.valueOf(name)) : DataResult.success((Object)species);
    }

    public Species() {
        this.setRegistryName(DynamicTrees.NULL);
    }

    public Species(ResourceLocation name, Family family) {
        this(name, family, family.getCommonLeaves());
    }

    public Species(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        this.setRegistryName(name);
        this.setUnlocalizedName(name.toString());
        this.family = family;
        this.family.addSpecies(this);
        this.setLeavesProperties(leavesProperties.isValid() ? leavesProperties : family.getCommonLeaves());
    }

    @Override
    public Species reset() {
        this.fruits.clear();
        this.pods.clear();
        this.envFactors.clear();
        this.genFeatures.clear();
        this.acceptableBlocksForGrowth.clear();
        this.primitiveSaplingRecipe.clear();
        this.perfectBiomes.clear();
        this.clearAcceptableSoils();
        return this;
    }

    @Override
    public Species setPreReloadDefaults() {
        return this.setDefaultGrowingParameters().setSaplingShape(CommonVoxelShapes.SAPLING).setSaplingSound(SoundType.GRASS);
    }

    @Override
    public Species setPostReloadDefaults() {
        if (!this.hasSeed()) {
            this.seed = this.getCommonSpecies().seed;
        }
        if (!this.hasAcceptableSoil()) {
            this.setStandardSoils();
        }
        return this;
    }

    public Species setDefaultGrowingParameters() {
        return this;
    }

    public float defaultSeedComposterChance() {
        return 0.3f;
    }

    public Family getFamily() {
        return this.family;
    }

    public void setFamily(Family family) {
        family.addSpecies(this);
        this.family = family;
    }

    public Species getCommonSpecies() {
        return this.family.getCommonSpecies();
    }

    public boolean isCommonSpecies() {
        return this.getCommonSpecies() == this;
    }

    public boolean isSeedCommon() {
        return this.getCommonSpecies().getSeed().orElse(null) == this.seed.get();
    }

    public Species setUnlocalizedName(String name) {
        this.unlocalizedName = "species." + name.replace(":", ".");
        return this;
    }

    public String getLocalizedName() {
        return I18n.get((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public Component getTextComponent() {
        return this.formatComponent((Component)Component.translatable((String)this.getUnlocalizedName()), ChatFormatting.AQUA);
    }

    public Species setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate) {
        this.tapering = tapering;
        this.signalEnergy = energy;
        this.upProbability = upProbability;
        this.lowestBranchHeight = lowestBranchHeight;
        this.growthRate = growthRate;
        return this;
    }

    public void setTapering(float tapering) {
        this.tapering = tapering;
    }

    public void setUpProbability(int upProbability) {
        this.upProbability = upProbability;
    }

    public void setLowestBranchHeight(int lowestBranchHeight) {
        this.lowestBranchHeight = lowestBranchHeight;
    }

    public void setSignalEnergy(float signalEnergy) {
        this.signalEnergy = signalEnergy;
    }

    public void setGrowthRate(float growthRate) {
        this.growthRate = growthRate;
    }

    public float getSignalEnergy() {
        return this.signalEnergy;
    }

    public float getEnergy(Level level, BlockPos rootPos) {
        return this.logicKit.getEnergy(new PositionalSpeciesContext(level, rootPos, this));
    }

    public float getGrowthRate(Level level, BlockPos rootPos) {
        return this.growthRate * this.seasonalGrowthFactor(LevelContext.create((LevelAccessor)level), rootPos);
    }

    public int getUpProbability() {
        return this.upProbability;
    }

    public int getProbabilityForCurrentDir() {
        return 1;
    }

    public int getLowestBranchHeight() {
        return this.lowestBranchHeight;
    }

    public float getTapering() {
        return this.tapering;
    }

    public boolean doesRequireTileEntity(LevelAccessor level, BlockPos pos) {
        return !this.isCommonSpecies() && !this.shouldOverrideCommon((BlockGetter)level, pos);
    }

    public boolean hasCommonOverride() {
        return this.commonOverride != null;
    }

    public void setCommonOverride(CommonOverride commonOverride) {
        this.commonOverride = commonOverride;
    }

    public boolean shouldOverrideCommon(BlockGetter level, BlockPos trunkPos) {
        if (Services.MISC.getCurrentServer() == null) {
            DynamicTrees.LOG.warn("shouldOverrideCommon was called before the server was loaded, will return false for now.");
            return false;
        }
        return this.hasCommonOverride() && this.commonOverride.test(level, trunkPos);
    }

    public Species setLeavesProperties(LeavesProperties leavesProperties) {
        this.leavesProperties = leavesProperties;
        leavesProperties.setFamily(this.getFamily());
        this.addValidLeafBlocks(leavesProperties);
        return this;
    }

    public LeavesProperties getLeavesProperties() {
        return this.leavesProperties;
    }

    public Optional<DynamicLeavesBlock> getLeavesBlock() {
        return this.leavesProperties.getDynamicLeavesBlock();
    }

    public Optional<Block> getPrimitiveLeaves() {
        return Optionals.ofBlock(this.leavesProperties.getPrimitiveLeaves().getBlock());
    }

    public void addValidLeafBlocks(LeavesProperties ... leaves) {
        for (LeavesProperties leaf : leaves) {
            if (this.validLeaves.contains(leaf)) continue;
            this.validLeaves.add(leaf);
        }
    }

    public int getLeafBlockIndex(DynamicLeavesBlock block) {
        int index = this.validLeaves.indexOf(block.properties);
        if (index < 0) {
            DynamicTrees.LOG.warn("Block {} not valid leaves for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    public LeavesProperties getValidLeavesProperties(int index) {
        if (index < this.validLeaves.size()) {
            return this.validLeaves.get(index);
        }
        DynamicTrees.LOG.warn("Attempted to get leaves properties of index {} but {} only has {} valid leaves.", new Object[]{index, this, this.validLeaves.size()});
        return this.validLeaves.get(0);
    }

    public DynamicLeavesBlock getValidLeafBlock(int index) {
        LeavesProperties properties = this.getValidLeavesProperties(index);
        if (!properties.getDynamicLeavesBlock().isPresent()) {
            return null;
        }
        return (DynamicLeavesBlock)properties.getDynamicLeavesState().getBlock();
    }

    public boolean isValidLeafBlock(DynamicLeavesBlock leavesBlock) {
        return this.validLeaves.stream().anyMatch(properties -> properties.getDynamicLeavesBlock().orElse(null) == leavesBlock);
    }

    public int colorTreeQuads(int defaultColor, FallingTreeEntityModel.TreeQuadData treeQuad) {
        return defaultColor;
    }

    public int leafColorMultiplier(Level level, BlockPos pos) {
        return this.getLeavesProperties().treeFallColorMultiplier(this.getLeavesProperties().getDynamicLeavesState(), (BlockAndTintGetter)level, pos);
    }

    public ItemStack getSeedStack(int qty) {
        return !this.hasSeed() ? ItemStack.EMPTY : new ItemStack((ItemLike)this.seed.get(), qty);
    }

    public boolean hasSeed() {
        return this.seed != null;
    }

    public Optional<Seed> getSeed() {
        return Optional.ofNullable(this.seed == null ? null : this.seed.get());
    }

    public boolean shouldGenerateSeed() {
        return this.shouldGenerateSeed != null && this.shouldGenerateSeed != false;
    }

    public void setShouldGenerateSeed(boolean shouldGenerateSeed) {
        this.shouldGenerateSeed = shouldGenerateSeed;
    }

    public Species setShouldGenerateSeedIfNull(boolean shouldGenerateSeed) {
        if (this.shouldGenerateSeed == null) {
            this.shouldGenerateSeed = shouldGenerateSeed;
        }
        return this;
    }

    public ResourceLocation getSeedName() {
        if (this.seedName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_seed");
        }
        return ResourceLocation.fromNamespaceAndPath((String)this.getRegistryName().getNamespace(), (String)this.seedName);
    }

    public void setSeedName(String name) {
        this.seedName = name;
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed(RegistryHandler.addItem(this.getSeedName(), () -> new Seed(this)));
    }

    public Species setSeed(Supplier<Seed> seedSup) {
        this.seed = seedSup;
        return this;
    }

    public List<ItemStack> getVoluntaryDrops(Level level, BlockPos rootPos, int fertility) {
        if (level.isClientSide) {
            return Collections.emptyList();
        }
        if (level.getServer() == null) {
            return List.of();
        }
        return this.getLootTable(level.getServer().reloadableRegistries(), species -> species.voluntaryDropsPath.get()).getRandomItems(this.createVoluntaryLootParams(level, rootPos, fertility));
    }

    private LootParams createVoluntaryLootParams(Level level, BlockPos rootPos, int fertility) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(rootPos)).withParameter(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(this.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), rootPos))).withParameter(DTLootContextParams.FERTILITY, (Object)fertility).create(DTLootParameterSets.VOLUNTARY);
    }

    public LootTable getLootTable(ReloadableServerRegistries.Holder lootTables, Function<Species, ResourceLocation> nameFunction) {
        LootTable table = lootTables.getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)nameFunction.apply(this)));
        return table == LootTable.EMPTY ? (this.isCommonSpecies() ? lootTables.getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)nameFunction.apply(this.getCommonSpecies()))) : LootTable.EMPTY) : table;
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume) {
        return this.getBranchesDrops(level, volume, ItemStack.EMPTY);
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume, ItemStack tool) {
        return this.getBranchesDrops(level, volume, tool, null);
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume, ItemStack tool, @Nullable Float explosionRadius) {
        this.processVolume(volume);
        if (level.isClientSide) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.family.getNumberOfValidBranchBlocks(); ++i) {
            int branchVolume = volume.getRawVolume(i);
            if (branchVolume <= 0) continue;
            BranchBlock branchBlock = this.family.getValidBranchBlock(i);
            drops.addAll(this.getDropsForBranchType(level, tool, explosionRadius, branchVolume, branchBlock));
        }
        this.cleanDropsList(drops);
        return drops;
    }

    public void processVolume(NetVolumeNode.Volume volume) {
        volume.multiplyVolume(Services.CONFIG.getDoubleConfig("treeHarvestMultiplier"));
        volume.multiplyVolume(this.getFamily().getLootVolumeMultiplier());
    }

    private List<ItemStack> getDropsForBranchType(Level level, ItemStack tool, @Nullable Float explosionRadius, int branchVolume, BranchBlock branchBlock) {
        if (level.getServer() == null) {
            return List.of();
        }
        return branchBlock.getLootTable(level.getServer().reloadableRegistries(), this).getRandomItems(this.createBranchesLootParams(level, branchVolume, tool, explosionRadius));
    }

    private LootParams createBranchesLootParams(Level level, int volume, ItemStack tool, @Nullable Float explosionRadius) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(DTLootContextParams.SPECIES, (Object)this).withParameter(DTLootContextParams.VOLUME, (Object)volume).withOptionalParameter(LootContextParams.EXPLOSION_RADIUS, (Object)explosionRadius).create(DTLootParameterSets.BRANCHES);
    }

    private void cleanDropsList(List<ItemStack> drops) {
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack drop = drops.get(i);
            if (drop.getItem() == Items.AIR) {
                drops.remove(i--);
            }
            if (drop.getCount() <= drop.getMaxStackSize()) continue;
            ItemStack copiedStack = drop.copy();
            copiedStack.setCount(drop.getCount() - drop.getMaxStackSize());
            drops.add(copiedStack);
            drop.setCount(drop.getMaxStackSize());
        }
    }

    public LogsAndSticks getLogsAndSticks(NetVolumeNode.Volume volume, boolean silkTouch, int fortuneLevel) {
        LinkedList<ItemStack> logsList = new LinkedList<ItemStack>();
        int[] volArray = volume.getRawVolumesArray();
        float stickVol = 0.0f;
        for (int i = 0; i < volArray.length; ++i) {
            float vol = (float)volArray[i] / 4096.0f;
            if (!(vol > 0.0f)) continue;
            stickVol += this.getFamily().getValidBranchBlock(i).getPrimitiveLogs(vol, logsList);
        }
        int sticks = (int)(stickVol * 8.0f);
        return new LogsAndSticks(logsList, sticks);
    }

    public boolean handleVoluntaryDrops(Level level, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int fertility) {
        int tickSpeed = level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if (tickSpeed > 0) {
            List<ItemStack> drops;
            double slowFactor = 3.0 / (double)tickSpeed;
            if (level.random.nextDouble() < slowFactor && !(drops = this.getVoluntaryDrops(level, rootPos, fertility)).isEmpty() && !endPoints.isEmpty()) {
                for (ItemStack drop : drops) {
                    BlockPos branchPos = endPoints.get(level.random.nextInt(endPoints.size()));
                    BlockPos itemPos = CoordUtils.getRayTraceFruitPos((LevelAccessor)level, this, treePos, branchPos = branchPos.above(), false);
                    if (itemPos == BlockPos.ZERO) continue;
                    ItemEntity itemEntity = new ItemEntity(level, (double)itemPos.getX() + 0.5, (double)itemPos.getY() + 0.5, (double)itemPos.getZ() + 0.5, drop);
                    Vec3 motion = new Vec3((double)itemPos.getX(), (double)itemPos.getY(), (double)itemPos.getZ()).subtract(new Vec3((double)treePos.getX(), (double)treePos.getY(), (double)treePos.getZ()));
                    float distAngle = 15.0f;
                    float launchSpeed = 4.0f;
                    motion = new Vec3(motion.x, 0.0, motion.y).normalize().yRot(level.random.nextFloat() * distAngle * 2.0f - distAngle).scale((double)(launchSpeed / 20.0f));
                    itemEntity.setDeltaMovement(motion.x, motion.y, motion.z);
                    return level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return true;
    }

    public void addPrimitiveSaplingRecipe(SeedSaplingRecipe recipe) {
        if (recipe.shouldReplaceSaplingWhenPlaced()) {
            recipe.getSaplingBlock().ifPresent(block -> DynamicSaplingBlock.registerSaplingReplacer(block.defaultBlockState(), this));
        }
        this.primitiveSaplingRecipe.add(recipe);
    }

    public Set<SeedSaplingRecipe> getPrimitiveSaplingRecipes() {
        return new HashSet<SeedSaplingRecipe>(this.primitiveSaplingRecipe);
    }

    public Species addPrimitiveSaplingItem(Item primitiveSaplingItem) {
        this.primitiveSaplingRecipe.add(new SeedSaplingRecipe(primitiveSaplingItem));
        return this;
    }

    public Species setSapling(Supplier<DynamicSaplingBlock> sapling) {
        this.saplingBlock = sapling;
        return this;
    }

    public boolean shouldGenerateSapling() {
        return this.shouldGenerateSapling != null && this.shouldGenerateSapling != false;
    }

    public void setShouldGenerateSapling(boolean shouldGenerateSapling) {
        this.shouldGenerateSapling = shouldGenerateSapling;
    }

    public Species setShouldGenerateSaplingIfNull(boolean shouldGenerateSapling) {
        if (this.shouldGenerateSapling == null) {
            this.shouldGenerateSapling = shouldGenerateSapling;
        }
        return this;
    }

    public Species generateSapling() {
        return !this.shouldGenerateSapling() || this.saplingBlock != null ? this : this.setSapling(RegistryHandler.addBlock(this.getSaplingRegName(), () -> new DynamicSaplingBlock(this)));
    }

    public Optional<DynamicSaplingBlock> getSapling() {
        return Optional.ofNullable(this.saplingBlock == null ? null : this.saplingBlock.get());
    }

    public Species selfOrLocationOverride(BlockGetter level, BlockPos pos) {
        return this.shouldUseLocationOverride() ? this.getFamily().getSpeciesForLocation(level, pos, this) : this;
    }

    public boolean shouldUseLocationOverride() {
        return !this.getSapling().isPresent() || this.isCommonSpecies();
    }

    public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
        DynamicSaplingBlock sapling;
        DynamicSaplingBlock commonSapling = this.getCommonSpecies().getSapling().orElse(null);
        DynamicSaplingBlock dynamicSaplingBlock = sapling = locationOverride ? commonSapling : this.getSapling().orElse(commonSapling);
        if (sapling == null || !level.getBlockState(pos).canBeReplaced() || !DynamicSaplingBlock.canSaplingStay((LevelReader)level, this, pos)) {
            return false;
        }
        level.playSound(null, pos, this.saplingSound.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
        level.setBlock(pos, sapling.defaultBlockState(), 3);
        return true;
    }

    public void addAcceptableBlockForGrowth(Block block) {
        this.acceptableBlocksForGrowth.add(block);
    }

    public boolean canSaplingGrow(LevelReader level, BlockPos pos) {
        return this.acceptableBlocksForGrowth.isEmpty() || this.acceptableBlocksForGrowth.stream().anyMatch(block -> block == level.getBlockState(pos.below()).getBlock());
    }

    public Species setCanSaplingGrowNaturally(boolean canSaplingGrowNaturally) {
        this.canSaplingGrowNaturally = canSaplingGrowNaturally;
        return this;
    }

    public boolean canSaplingGrowNaturally(Level level, BlockPos pos) {
        return this.canSaplingGrowNaturally && this.canSaplingGrow((LevelReader)level, pos);
    }

    public boolean canSaplingConsumeBoneMeal(LevelReader level, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow(level, pos);
    }

    public boolean canSaplingGrowAfterBoneMeal(Level level, RandomSource rand, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow((LevelReader)level, pos);
    }

    public int saplingFireSpread() {
        return 0;
    }

    public int saplingFlammability() {
        return 0;
    }

    public final boolean transitionToTree(Level level, BlockPos pos) {
        return !Services.EVENT.postTransitionSaplingToTreeEvent(this, level, pos) && this.shouldTransitionToTree(level, pos) && this.transitionToTree(level, pos, this.getFamily());
    }

    protected boolean shouldTransitionToTree(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos.above()) && this.isAcceptableSoil((LevelReader)level, pos.below(), level.getBlockState(pos.below()));
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
        level.setBlockAndUpdate(pos.above(), this.getLeavesProperties().getDynamicLeavesState());
        this.placeRootyDirtBlock((LevelAccessor)level, pos.below(), 15);
        if (this.doesRequireTileEntity((LevelAccessor)level, pos)) {
            SpeciesBlockEntity speciesBlockEntity = (SpeciesBlockEntity)DTRegistries.SPECIES_BLOCK_ENTITY.get().create(pos.below(), level.getBlockState(pos.below()));
            if (speciesBlockEntity == null) {
                return true;
            }
            level.setBlockEntity((BlockEntity)speciesBlockEntity);
            speciesBlockEntity.setSpecies(this);
        }
        return true;
    }

    public VoxelShape getSaplingShape() {
        return this.saplingShape;
    }

    public Species setSaplingShape(VoxelShape saplingShape) {
        this.saplingShape = saplingShape;
        return this;
    }

    public ResourceLocation getSaplingRegName() {
        if (this.saplingName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_sapling");
        }
        return ResourceLocation.fromNamespaceAndPath((String)this.getRegistryName().getNamespace(), (String)this.saplingName);
    }

    public String getSaplingModelName() {
        return "block/saplings/" + Objects.requireNonNullElseGet(this.saplingName, () -> this.getRegistryName().getPath());
    }

    public void setSaplingName(String name) {
        this.saplingName = name;
    }

    public void setTintSapling(Boolean tintSapling) {
        this.tintSapling = tintSapling;
    }

    public int saplingColorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
        if (this.tintSapling.booleanValue()) {
            if (tintIndex == 0) {
                return this.getLeavesProperties().foliageColorMultiplier(state, level, pos);
            }
            if (tintIndex == 1) {
                return this.family.getRootColor(state, true);
            }
            return -1;
        }
        return -1;
    }

    public SoundType getSaplingSound() {
        return this.saplingSound;
    }

    public Species setSaplingSound(SoundType saplingSound) {
        this.saplingSound = saplingSound;
        return this;
    }

    public boolean placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, int fertility) {
        BlockState dirtState = level.getBlockState(rootPos);
        Block dirt = dirtState.getBlock();
        if (!SoilHelper.isSoilRegistered(dirt) && !(dirt instanceof SoilBlock)) {
            DynamicTrees.LOG.warn("Rooty Dirt block NOT FOUND for soil {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)dirt));
            this.placeRootyDirtBlock(level, rootPos, Blocks.DIRT.defaultBlockState(), fertility);
            return false;
        }
        if (dirt instanceof SoilBlock) {
            this.updateRootyDirtBlock(level, rootPos, dirtState, fertility);
        } else if (SoilHelper.isSoilRegistered(dirt)) {
            this.placeRootyDirtBlock(level, rootPos, dirtState, fertility);
        }
        BlockEntity tileEntity = level.getBlockEntity(rootPos);
        if (tileEntity instanceof SpeciesBlockEntity) {
            SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)tileEntity;
            speciesTE.setSpecies(this);
        }
        return true;
    }

    private void placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, BlockState primitiveDirtState, int fertility) {
        SoilProperties soilProperties = this.forceSoil != null ? this.forceSoil : SoilHelper.getProperties(primitiveDirtState.getBlock());
        soilProperties.getBlock().ifPresent(block -> level.setBlock(rootPos, soilProperties.getSoilState(primitiveDirtState, fertility, this.doesRequireTileEntity(level, rootPos)), 3));
    }

    private void updateRootyDirtBlock(LevelAccessor level, BlockPos rootPos, BlockState soilState, int fertility) {
        if (soilState.getBlock() instanceof SoilBlock) {
            level.setBlock(rootPos, (BlockState)((BlockState)soilState.setValue((Property)SoilBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).setValue((Property)SoilBlock.IS_VARIANT, (Comparable)Boolean.valueOf(this.doesRequireTileEntity(level, rootPos))), 3);
        }
    }

    public SoilProperties getForceSoil() {
        return this.forceSoil;
    }

    public Species setForceSoil(SoilProperties soil) {
        this.forceSoil = soil;
        return this;
    }

    public Species setSoilLongevity(int longevity) {
        this.soilLongevity = longevity;
        return this;
    }

    public int getSoilLongevity(Level level, BlockPos rootPos) {
        return (int)(this.biomeSuitability(level, rootPos) * (float)this.soilLongevity);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = Mth.clamp((int)maxBranchRadius, (int)1, (int)this.getFamily().getMaxBranchRadius());
    }

    public Species addAcceptableSoils(String ... soilTypes) {
        this.soilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species addAcceptableSoilsForWorldGen(String ... soilTypes) {
        this.worldGenSoilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species clearAcceptableSoils() {
        this.soilTypeFlags = 0;
        this.worldGenSoilTypeFlags = 0;
        return this;
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils("dirt_like");
    }

    public boolean hasAcceptableSoil() {
        return this.soilTypeFlags != 0;
    }

    public BlockPos moveGroundPosWorldgen(LevelAccessor world, BlockPos pos, BlockState soilBlockState) {
        if (!soilBlockState.is(BlockTags.SNOW)) {
            return pos;
        }
        for (int steps = 8; steps > 0 && soilBlockState.is(BlockTags.SNOW); --steps) {
            pos = pos.below();
            soilBlockState = world.getBlockState(pos);
        }
        return pos;
    }

    public boolean isAcceptableSoil(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.soilTypeFlags);
    }

    public boolean isAcceptableSoil(String ... soilTypes) {
        return (SoilHelper.getSoilFlags(soilTypes) & this.soilTypeFlags) != 0;
    }

    public boolean isAcceptableSoil(LevelReader level, BlockPos pos, BlockState soilBlockState) {
        return this.isAcceptableSoil(soilBlockState);
    }

    public void setAllowedWaterHeightForWorldgen(int allowedWaterHeightForWorldgen) {
        this.allowedWaterHeightForWorldgen = allowedWaterHeightForWorldgen;
    }

    public int getAllowedWaterHeightForWorldgen() {
        return this.allowedWaterHeightForWorldgen;
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        boolean isAcceptableSoil = this.isAcceptableSoilForWorldgen(soilBlockState);
        if (isAcceptableSoil && this.isWater(soilBlockState)) {
            int maxH = this.getAllowedWaterHeightForWorldgen();
            int waterBelow = this.countWaterBlocksBelow(level, pos, maxH + 2);
            return waterBelow <= maxH && this.isAcceptableSoilForWorldgen(level.getBlockState(pos.below(waterBelow)));
        }
        return isAcceptableSoil;
    }

    public boolean isAcceptableSoilForWorldgen(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.soilTypeFlags) || SoilHelper.isSoilAcceptable(soilBlockState, this.worldGenSoilTypeFlags);
    }

    protected boolean isWater(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, SoilHelper.getSoilFlags("water_like"));
    }

    protected int countWaterBlocksBelow(LevelAccessor level, BlockPos startPos, int maxCount) {
        BlockState downState;
        int i;
        for (i = 0; i <= maxCount && this.isWater(downState = level.getBlockState(startPos.below(i))); ++i) {
        }
        return i;
    }

    public void setPlantableOnFluid(boolean plantableOnFluid) {
        this.plantableOnFluid = plantableOnFluid;
    }

    public boolean isPlantableOnFluid() {
        return this.plantableOnFluid;
    }

    public boolean soilDestroyAction(Level level, @NotNull BlockPos rootPos, BlockState state, @NotNull Player player) {
        return false;
    }

    public boolean update(Level level, SoilBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        List<BlockPos> ends = this.getEnds(level, treePos, treeBase);
        if (this.handleRot((LevelAccessor)level, ends, rootPos, treePos, fertility, false)) {
            return false;
        }
        if (natural) {
            this.handleVoluntaryDrops(level, ends, rootPos, treePos, fertility);
            if (this.handleDisease(level, treeBase, treePos, random, fertility)) {
                return true;
            }
        }
        return this.grow(level, rootyDirt, rootPos, fertility, treeBase, treePos, random, natural);
    }

    protected final List<BlockPos> getEnds(Level level, BlockPos treePos, TreePart treeBase) {
        FindEndsNode endFinder = new FindEndsNode();
        treeBase.analyse(level.getBlockState(treePos), (LevelAccessor)level, treePos, null, new MapSignal(endFinder));
        return endFinder.getEnds();
    }

    public boolean handleRot(LevelAccessor level, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int fertility, boolean worldGen) {
        Iterator<BlockPos> iter = ends.iterator();
        SimpleVoxmap leafMap = this.getLeavesProperties().getCellKit().getLeafCluster();
        while (iter.hasNext()) {
            BlockPos endPos = iter.next();
            BlockState branchState = level.getBlockState(endPos);
            BranchBlock branch = TreeHelper.getBranch(branchState);
            if (branch == null) continue;
            int radius = branch.getRadius(branchState);
            float rotChance = this.rotChance(level, endPos, level.getRandom(), radius);
            if (!branch.checkForRot(level, endPos, this, fertility, radius, level.getRandom(), rotChance, worldGen) && radius == this.family.getPrimaryThickness()) continue;
            if (worldGen && leafMap != null) {
                TreeHelper.ageVolume(level, endPos.below(leafMap.getCenter().getY()), leafMap.getLenX() / 2, leafMap.getLenY(), 2, true);
            }
            iter.remove();
        }
        return ends.isEmpty() && !TreeHelper.isBranch(level.getBlockState(treePos));
    }

    public void setDoesRot(boolean doesRot) {
        this.doesRot = doesRot;
    }

    public boolean rot(LevelAccessor level, BlockPos pos, int neighborCount, int radius, int fertility, RandomSource random, boolean rapid, boolean growLeaves) {
        if (!this.doesRot) {
            return false;
        }
        if (radius <= this.family.getPrimaryThickness()) {
            if (!this.getLeavesProperties().getDynamicLeavesBlock().isPresent()) {
                return false;
            }
            if (growLeaves) {
                DynamicLeavesBlock leaves = (DynamicLeavesBlock)this.getLeavesProperties().getDynamicLeavesState().getBlock();
                for (Direction dir : upFirst) {
                    if (0 == leaves.growLeavesIfLocationIsSuitable(level, this.getLeavesProperties(), pos.relative(dir), 0)) continue;
                    return false;
                }
            }
        }
        int maxBranchRotRadius = Services.CONFIG.getIntConfig("maxBranchRotRadius");
        if (rapid || maxBranchRotRadius != 0 && radius <= maxBranchRotRadius) {
            BranchBlock branch = TreeHelper.getBranch(level.getBlockState(pos));
            if (branch != null) {
                branch.rot(level, pos);
            }
            this.postRot(new PostRotContext(level, pos, this, radius, neighborCount, fertility, rapid));
            return true;
        }
        return false;
    }

    public void postRot(PostRotContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_ROT, context));
    }

    public float rotChance(LevelAccessor level, BlockPos pos, RandomSource rand, int radius) {
        if (radius == 0) {
            return 0.0f;
        }
        return 0.3f + 1.0f / (float)radius;
    }

    public boolean grow(Level level, SoilBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        float growthRate = (float)((double)this.getGrowthRate(level, rootPos) * Services.CONFIG.getDoubleConfig("treeGrowthMultiplier"));
        do {
            if (fertility <= 0 || !(growthRate > random.nextFloat())) continue;
            GrowSignal signal = this.sendGrowthSignal(treeBase, level, treePos, rootPos, rootyDirt.getTrunkDirection((BlockGetter)level, rootPos));
            int soilLongevity = this.getSoilLongevity(level, rootPos) * (signal.success ? 1 : 16);
            if (soilLongevity <= 0 || random.nextInt(soilLongevity) == 0) {
                rootyDirt.setFertility(level, rootPos, fertility - 1);
            }
            if (!signal.choked) continue;
            fertility = 0;
            rootyDirt.setFertility(level, rootPos, fertility);
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, rootPos, new MapSignal(new ShrinkerNode(signal.getSpecies())));
        } while ((growthRate -= 1.0f) > 0.0f);
        this.postGrow(level, rootPos, treePos, fertility, natural);
        return true;
    }

    protected GrowSignal sendGrowthSignal(TreePart treeBase, Level level, BlockPos treePos, BlockPos rootPos, Direction defaultDir) {
        GrowSignal signal = new GrowSignal(this, rootPos, this.getEnergy(level, rootPos), level.random, defaultDir);
        return treeBase.growSignal(level, treePos, signal);
    }

    public Species setGrowthLogicKit(GrowthLogicKit logicKit) {
        this.logicKit = (GrowthLogicKitConfiguration)logicKit.getDefaultConfiguration();
        return this;
    }

    public Species setGrowthLogicKit(GrowthLogicKitConfiguration logicKit) {
        this.logicKit = logicKit;
        return this;
    }

    public GrowthLogicKitConfiguration getGrowthLogicKit() {
        return this.logicKit;
    }

    public void setCanBoneMealTree(boolean canBoneMealTree) {
        this.canBoneMealTree = canBoneMealTree;
    }

    public boolean canBoneMealTree() {
        return this.canBoneMealTree;
    }

    public boolean postGrow(Level level, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(level, rootPos, this, treePos, fertility, natural)));
        return true;
    }

    public boolean handleDisease(Level level, TreePart baseTreePart, BlockPos treePos, RandomSource random, int fertility) {
        if (fertility == 0 && Services.CONFIG.getDoubleConfig("diseaseChance") > (double)random.nextFloat()) {
            baseTreePart.analyse(level.getBlockState(treePos), (LevelAccessor)level, treePos, Direction.DOWN, new MapSignal(new DiseaseNode(this)));
            return true;
        }
        return false;
    }

    public Species envFactor(TagKey<Biome> type, float factor) {
        this.envFactors.put(type, Float.valueOf(factor));
        return this;
    }

    public float biomeSuitability(Level level, BlockPos pos) {
        Holder biomeHolder = level.getBiome(pos);
        Biome biome = (Biome)biomeHolder.value();
        BiomeSuitabilityEventResult result = Services.EVENT.postBiomeSuitabilityEvent(level, biome, this, pos);
        if (result.handled()) {
            return result.suitability();
        }
        float ugs = (float)Services.CONFIG.getDoubleConfig("scaleBiomeGrowthRate").doubleValue();
        if (ugs == 1.0f || this.isBiomePerfect((Holder<Biome>)biomeHolder)) {
            return 1.0f;
        }
        float suit = Species.defaultSuitability();
        for (TagKey t : biomeHolder.tags().toList()) {
            suit *= this.envFactors.getOrDefault(t, Float.valueOf(1.0f)).floatValue();
        }
        suit = ugs <= 0.5f ? ugs * 2.0f * suit : ((1.0f - ugs) * suit + (ugs - 0.5f)) * 2.0f;
        return Mth.clamp((float)suit, (float)0.0f, (float)1.0f);
    }

    public boolean isBiomePerfect(Holder<Biome> biome) {
        return this.perfectBiomes.contains(biome);
    }

    public IDTBiomeHolderSet getPerfectBiomes() {
        return this.perfectBiomes;
    }

    public static float defaultSuitability() {
        return 0.85f;
    }

    public void setSeasonalGrowthOffset(@Nullable Float offset) {
        this.seasonalGrowthOffset = offset;
    }

    public void setSeasonalSeedDropOffset(@Nullable Float offset) {
        this.seasonalSeedDropOffset = offset;
    }

    public void setSeasonalFruitingOffset(@Nullable Float offset) {
        this.seasonalFruitingOffset = offset;
    }

    public float seasonalGrowthFactor(LevelContext levelContext, BlockPos rootPos) {
        return this.seasonalGrowthOffset != null ? SeasonHelper.globalSeasonalGrowthFactor(levelContext, rootPos, -this.seasonalGrowthOffset.floatValue()) : 1.0f;
    }

    public float seasonalSeedDropFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonalSeedDropOffset != null ? SeasonHelper.globalSeasonalSeedDropFactor(levelContext, pos, -this.seasonalSeedDropOffset.floatValue()) : 1.0f;
    }

    public float seasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonalFruitingOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, pos, -this.seasonalFruitingOffset.floatValue(), false) : 1.0f;
    }

    public void inheritSeasonalFruitingOffsetToFruits() {
        this.fruits.forEach(fruit -> fruit.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public void inheritSeasonalFruitingOffsetToPods() {
        this.pods.forEach(pod -> pod.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public int getSeasonalTooltipFlags(LevelContext levelContext) {
        float seasonStart = 0.16666667f;
        float seasonEnd = 0.8333333f;
        float threshold = 0.75f;
        if (this.hasFruits() || this.hasPods()) {
            int seasonFlags = 0;
            for (int i = 0; i < 4; ++i) {
                boolean isValidSeason = false;
                if (this.seasonalFruitingOffset != null) {
                    float prod2;
                    float prod1 = SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, new BlockPos(0, (int)(((float)i + 0.16666667f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true);
                    if (Math.min(prod1, prod2 = SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, new BlockPos(0, (int)(((float)i + 0.8333333f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true)) > 0.75f) {
                        isValidSeason = true;
                    }
                } else {
                    isValidSeason = true;
                }
                if (!isValidSeason) continue;
                seasonFlags |= 1 << i;
            }
            return seasonFlags;
        }
        return 0;
    }

    public Species setFlowerSeasonHold(float min, float max) {
        this.flowerSeasonHoldMin = min;
        this.flowerSeasonHoldMax = max;
        return this;
    }

    public boolean testFlowerSeasonHold(Float seasonValue) {
        if (this.seasonalFruitingOffset == null) {
            return false;
        }
        return SeasonHelper.isSeasonBetween(seasonValue, this.flowerSeasonHoldMin + this.seasonalFruitingOffset.floatValue(), this.flowerSeasonHoldMax + this.seasonalFruitingOffset.floatValue());
    }

    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (this.canBoneMealTree() && itemStack.is(DTItemTags.FERTILIZER)) {
            return new FertilizeSubstance().setAmount(2).setGrow(true).setPulses(Services.CONFIG.getIntConfig("boneMealGrowthPulses"));
        }
        Item item = itemStack.getItem();
        if (item instanceof SubstanceEffectProvider) {
            SubstanceEffectProvider provider = (SubstanceEffectProvider)item;
            return provider.getSubstanceEffect(itemStack);
        }
        if (itemStack.is(DTItemTags.ENHANCED_FERTILIZER)) {
            return new GrowthSubstance();
        }
        return null;
    }

    public boolean applySubstance(Level level, BlockPos rootPos, BlockPos hitPos, @Nullable Player player, @Nullable InteractionHand hand, ItemStack itemStack) {
        SubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            boolean applied = effect.apply(level, rootPos);
            if (applied && effect.isLingering() && !level.isClientSide()) {
                LingeringEffectorEntity entity = (LingeringEffectorEntity)DTRegistries.LINGERING_EFFECTOR.get().create(level);
                if (entity != null) {
                    entity.setData(level, rootPos, effect);
                    if (entity.isAlive()) {
                        level.addFreshEntity((Entity)entity);
                    }
                }
                return true;
            }
            return applied;
        }
        return false;
    }

    public boolean onTreeActivated(Family.TreeActivationContext context) {
        if (context.heldItem() != null && this.applySubstance(context.level(), context.rootPos(), context.hitPos(), context.player(), context.hand(), context.heldItem())) {
            Species.consumePlayerItem(context.player(), context.hand(), context.heldItem());
            return true;
        }
        return false;
    }

    public static void consumePlayerItem(Player player, InteractionHand hand, ItemStack heldItem) {
        if (!player.isCreative()) {
            Item item = heldItem.getItem();
            if (item instanceof Emptiable) {
                Emptiable emptiable = (Emptiable)item;
                player.setItemInHand(hand, emptiable.getEmptyContainer());
            } else if (heldItem.getItem() == Items.POTION) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            } else {
                heldItem.shrink(1);
            }
        }
    }

    public boolean useDefaultWailaBody() {
        return true;
    }

    public Species setAlwaysShowOnWaila(boolean alwaysShowOnWaila) {
        this.alwaysShowOnWaila = alwaysShowOnWaila;
        return this;
    }

    public boolean showSpeciesOnWaila() {
        if (this.alwaysShowOnWaila == null) {
            return this != this.getFamily().getCommonSpecies();
        }
        return this.alwaysShowOnWaila;
    }

    public Species getMegaSpecies() {
        return this.megaSpecies;
    }

    public Species getPreMegaSpecies() {
        return this.preMegaSpecies;
    }

    public boolean isMegaSpecies() {
        return this.preMegaSpecies.isValid();
    }

    public void setMegaSpecies(Species megaSpecies) {
        this.megaSpecies = megaSpecies;
        megaSpecies.preMegaSpecies = this;
    }

    public void setCanCraftMegaSeed(boolean canCraftMegaSeed) {
        this.canCraftMegaSeed = canCraftMegaSeed;
    }

    public boolean canCraftMegaSeed() {
        return this.canCraftMegaSeed;
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return this.getFamily().selectAnimationHandler(fallingEntity);
    }

    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        return null;
    }

    public boolean canEncodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return block instanceof DynamicLeavesBlock;
    }

    public int encodeLeavesPos(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return (Integer)state.getValue((Property)DynamicLeavesBlock.DISTANCE) << 24 | BranchDestructionData.encodeRelBlockPos(pos);
    }

    public int encodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return this.getLeafBlockIndex((DynamicLeavesBlock)block);
    }

    public boolean leavesAreSolid() {
        return this.getLeavesProperties().getPrimitiveLeaves().isSolid();
    }

    public float falloverParticleFlingMultiplier() {
        return 1.0f;
    }

    public SoundEvent getFallingTreeStartSound(float treeVolume, boolean hasLeaves) {
        return treeVolume > this.bigTreeSoundThreshold ? DTRegistries.FALLING_TREE_BIG_START.get() : DTRegistries.FALLING_TREE_MEDIUM_START.get();
    }

    public SoundEvent getFallingTreeEndSound(float treeVolume, boolean hasLeaves) {
        return treeVolume > this.bigTreeSoundThreshold ? DTRegistries.FALLING_TREE_BIG_END.get() : DTRegistries.FALLING_TREE_MEDIUM_END.get();
    }

    public float getFallingTreePitch(float treeVolume) {
        return treeVolume > this.bigTreeSoundThreshold ? 25.0f / treeVolume : 10.0f / (5.0f + treeVolume * 0.6f);
    }

    public float getFallingBranchPitch(float treeVolume) {
        return 1.0f / treeVolume;
    }

    public SoundEvent getFallingTreeHitWaterSound(float treeVolume, boolean hasLeaves) {
        return DTRegistries.FALLING_TREE_HIT_WATER.get();
    }

    public SoundEvent getFallingBranchEndSound(float treeVolume, boolean hasLeaves, boolean fellOnWater) {
        return fellOnWater ? (hasLeaves ? DTRegistries.FALLING_TREE_SMALL_HIT_WATER.get() : SoundEvents.PLAYER_SPLASH) : (hasLeaves ? DTRegistries.FALLING_TREE_SMALL_END.get() : DTRegistries.FALLING_TREE_SMALL_END_BARE.get());
    }

    public void setBigTreeSoundThreshold(float bigTreeSoundThreshold) {
        this.bigTreeSoundThreshold = bigTreeSoundThreshold;
    }

    public PottedSaplingBlock getPottedSapling() {
        return DTRegistries.POTTED_SAPLING.get();
    }

    public boolean generate(DynamicTreeGenerationContext context) {
        JoCode code;
        AtomicBoolean fullGen = new AtomicBoolean(false);
        FullGenerationContext fullGenContext = new FullGenerationContext(context.level(), (BlockPos)context.rootPos(), this, context.biome(), context.radius(), context.isWorldGen());
        this.genFeatures.forEach(configuration -> fullGen.set(fullGen.get() || configuration.generate(GenFeature.Type.FULL, fullGenContext) != false));
        if (fullGen.get()) {
            return true;
        }
        if (!this.shouldGenerate(context.levelContext(), (BlockPos)context.rootPos())) {
            return false;
        }
        if (!JoCodeRegistry.getCodes(this.getRegistryName(), false).isEmpty() && (code = JoCodeRegistry.getRandomCode(this.getRegistryName(), context.radius(), context.random())) != null) {
            code.generate(context);
            return true;
        }
        return false;
    }

    private boolean shouldGenerate(LevelContext levelContext, BlockPos rootPos) {
        BlockPos.MutableBlockPos pos = rootPos.above().mutable();
        int i = 0;
        while ((float)i < this.signalEnergy) {
            if (!DynamicTreeFeature.validTreePos((LevelSimulatedReader)levelContext.accessor(), (BlockPos)pos)) {
                return false;
            }
            pos.move(Direction.UP);
            ++i;
        }
        return true;
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCode(joCodeString);
    }

    public RootsJoCode getRootsJoCode(String joCodeString) {
        return new RootsJoCode(joCodeString);
    }

    public Collection<JoCode> getJoCodes() {
        return JoCodeRegistry.getCodes(this.getRegistryName(), false).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<JoCode> getRootsJoCodes() {
        return JoCodeRegistry.getCodes(this.getRegistryName(), true).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Species addGenFeature(GenFeature feature) {
        return this.addGenFeature((GenFeatureConfiguration)feature.getDefaultConfiguration());
    }

    public Species addGenFeature(GenFeatureConfiguration configuration) {
        if (configuration.shouldApply(this)) {
            this.genFeatures.add(configuration);
        }
        return this;
    }

    public boolean hasGenFeatures() {
        return !this.genFeatures.isEmpty();
    }

    public List<GenFeatureConfiguration> getGenFeatures() {
        return this.genFeatures;
    }

    public BlockPos preGeneration(LevelAccessor level, BlockPos.MutableBlockPos rootPos, int radius, Direction facing, boolean worldGen, JoCode joCode) {
        this.genFeatures.forEach(configuration -> rootPos.set((Vec3i)configuration.generate(GenFeature.Type.PRE_GENERATION, new PreGenerationContext(level, (BlockPos)rootPos, this, radius, facing, worldGen, joCode))));
        return rootPos.immutable();
    }

    public void postGeneration(PostGenerationContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GENERATION, context));
    }

    public float getWorldGenTaperingFactor() {
        return 1.5f;
    }

    public int getWorldGenLeafMapHeight() {
        return this.worldGenLeafMapHeight;
    }

    public void setWorldGenLeafMapHeight(int worldGenLeafMapHeight) {
        this.worldGenLeafMapHeight = worldGenLeafMapHeight;
    }

    public int getWorldGenAgeIterations() {
        return 3;
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return this.getNodeInflator(leafMap, this.getMaxBranchRadius());
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap, int maxRadius) {
        return new InflatorNode(this, leafMap, maxRadius);
    }

    public int coordHashCode(BlockPos pos) {
        return CoordUtils.coordHashCode(pos, 2);
    }

    public boolean hasFruit(Fruit fruit) {
        return this.fruits.contains(fruit);
    }

    public boolean hasFruits() {
        return !this.fruits.isEmpty();
    }

    public void addFruits(Collection<Fruit> fruits) {
        this.fruits.addAll(fruits);
    }

    public Set<Fruit> getFruits() {
        return Collections.unmodifiableSet(this.fruits);
    }

    public boolean hasPod(Pod pod) {
        return this.pods.contains(pod);
    }

    public boolean hasPods() {
        return !this.pods.isEmpty();
    }

    public void addPods(Collection<Pod> pods) {
        this.pods.addAll(pods);
    }

    public Set<Pod> getPods() {
        return Collections.unmodifiableSet(this.pods);
    }

    public List<TagKey<Block>> defaultSaplingTags() {
        return Collections.singletonList(DTBlockTags.SAPLINGS);
    }

    public List<TagKey<Item>> defaultSeedTags() {
        return Collections.singletonList(DTItemTags.SEEDS);
    }

    @Override
    public void generateStateData(DTDataProvider.BlockState provider) {
        this.saplingStateGenerator.get().generate(provider, this);
    }

    @Override
    public void generateItemModelData(DTDataProvider.ItemModel provider) {
        this.seedItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public void generateLangData(DTDataProvider.Language provider) {
        this.speciesLangGenerator.get().generate(provider, this);
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public void setLangOverrides(Map<String, String> textureOverrides) {
        this.langOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public Optional<String> getLangOverride(String key) {
        return Optional.ofNullable(this.langOverrides.getOrDefault(key, null));
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        if (this.modelOverrides.containsKey(SAPLING)) {
            return this.modelOverrides.get(SAPLING);
        }
        return DynamicTrees.location("block/smartmodel/sapling");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation leavesLoc = this.getLeavesProperties().getTexturePath("leaves").orElse(leavesTextureLocation);
        ResourceLocation logLoc = this.getFamily().getTexturePath("branch").orElse(barkTextureLocation);
        textureConsumer.accept("log", logLoc);
        textureConsumer.accept("leaves", leavesLoc);
    }

    public ResourceLocation getSeedParentModelLocation() {
        if (this.modelOverrides.containsKey(SEED_PARENT)) {
            return this.modelOverrides.get(SEED_PARENT);
        }
        return DynamicTrees.location("item/standard_seed");
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getSapling().ifPresent(sapling -> this.defaultSaplingTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add((Object)sapling);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey((Object)sapling));
            }
        }));
    }

    public void addGeneratedItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAppender) {
        if (!this.hasSeed()) {
            return;
        }
        this.getSeed().ifPresent(seed -> this.defaultSeedTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).add((Object)seed);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).addOptional(BuiltInRegistries.ITEM.getKey((Object)seed));
            }
        }));
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return this.seed != null;
    }

    public ResourceLocation getVoluntaryDropsPath() {
        return this.voluntaryDropsPath.get();
    }

    public LootTable.Builder createVoluntaryDrops(HolderLookup.Provider registries) {
        return DTLootTableBuilder.createVoluntaryDrops(this.seed.get(), registries);
    }

    public void setDropSeeds(boolean dropSeeds) {
        this.dropSeeds = dropSeeds;
    }

    public boolean shouldDropSeeds() {
        return Optional.ofNullable(this.dropSeeds).orElse(!this.hasFruits());
    }

    @Override
    public String toLoadDataString() {
        RegistryHandler registryHandler = RegistryHandler.get(this.getRegistryName().getNamespace());
        return this.getString(Pair.of((Object)SEED, this.seed != null ? BuiltInRegistries.ITEM.getKey((Object)this.seed.get()) : null), Pair.of((Object)SAPLING, this.saplingBlock != null ? "Block{" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this.saplingBlock.get())) + "}" : null));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"tapering", (Object)Float.valueOf(this.tapering)), Pair.of((Object)"upProbability", (Object)this.upProbability), Pair.of((Object)"lowestBranchHeight", (Object)this.lowestBranchHeight), Pair.of((Object)"signalEnergy", (Object)Float.valueOf(this.signalEnergy)), Pair.of((Object)"growthRate", (Object)Float.valueOf(this.growthRate)), Pair.of((Object)"soilLongevity", (Object)this.soilLongevity), Pair.of((Object)"soilTypeFlags", (Object)this.soilTypeFlags), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"leavesProperties", (Object)this.leavesProperties), Pair.of((Object)"envFactors", this.envFactors), Pair.of((Object)"megaSpecies", (Object)this.megaSpecies), Pair.of((Object)SEED, this.seed), Pair.of((Object)"primitive_sapling", (Object)DynamicSaplingBlock.SAPLING_REPLACERS.entrySet().stream().filter(entry -> entry.getValue() == this).map(Map.Entry::getKey).findAny().orElse(Blocks.AIR)), Pair.of((Object)"perfectBiomes", (Object)this.perfectBiomes), Pair.of((Object)"acceptableBlocksForGrowth", this.acceptableBlocksForGrowth), Pair.of((Object)"genFeatures", this.genFeatures));
    }

    public static Species findSpecies(String name) {
        return Species.findSpecies(ResourceLocationUtils.parseDTLocation(name));
    }

    public static Species findSpecies(ResourceLocation name) {
        return (Species)REGISTRY.get(name);
    }

    public static Species findSpeciesSloppy(String name) {
        ResourceLocation resourceLocation = ResourceLocationUtils.parseDTLocation(name);
        if (REGISTRY.has(resourceLocation)) {
            return Species.findSpecies(resourceLocation);
        }
        for (Species species : REGISTRY) {
            if (!species.getRegistryName().getPath().equals(resourceLocation.getPath())) continue;
            return species;
        }
        return NULL_SPECIES;
    }

    public static List<ResourceLocation> getSpeciesDirectory() {
        return new ArrayList<ResourceLocation>(REGISTRY.getRegistryNames());
    }

    @FunctionalInterface
    public static interface CommonOverride
    extends BiPredicate<BlockGetter, BlockPos> {
    }

    public static class LogsAndSticks {
        public List<ItemStack> logs;
        public final int sticks;

        public LogsAndSticks(List<ItemStack> logs, int sticks) {
            this.logs = logs;
            this.sticks = Services.CONFIG.getBoolConfig("dropSticks") != false ? sticks : 0;
        }
    }

    public record BiomeSuitabilityEventResult(boolean handled, float suitability) {
    }
}

