/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.species;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BasicRootsBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.block.soil.SpeciesBlockEntity;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import com.dtteam.dynamictrees.worldgen.JoCode;
import com.dtteam.dynamictrees.worldgen.JoCodeRegistry;
import com.mojang.datafixers.util.Function3;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class UndergroundRootsSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = UndergroundRootsSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)UndergroundRootsSpecies::new));
    protected GrowthLogicKitConfiguration rootLogicKit = GrowthLogicKitConfiguration.getDefault();
    private int minWorldGenHeightOffset = 2;
    private int maxWorldGenHeightOffset = 6;
    protected float rootSignalEnergy = 16.0f;
    protected float rootTapering = 0.3f;
    protected int rootGrowthMultiplier = 15;
    protected int updateSoilOnWaterRadius = 5;

    public void setMinWorldGenHeightOffset(int minWorldGenHeightOffset) {
        this.minWorldGenHeightOffset = minWorldGenHeightOffset;
    }

    public void setMaxWorldGenHeightOffset(int maxWorldGenHeightOffset) {
        this.maxWorldGenHeightOffset = maxWorldGenHeightOffset;
    }

    public void setRootGrowthMultiplier(int rootGrowthMultiplier) {
        this.rootGrowthMultiplier = rootGrowthMultiplier;
    }

    public void setUpdateSoilOnWaterRadius(int updateSoilOnWaterRadius) {
        this.updateSoilOnWaterRadius = updateSoilOnWaterRadius;
    }

    public UndergroundRootsSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        if (!(family instanceof UndergroundRootsFamily)) {
            throw new RuntimeException("Family " + String.valueOf(family.getRegistryName()) + " for Underground Roots Species " + String.valueOf(this.getRegistryName()) + " is not of type " + String.valueOf(UndergroundRootsFamily.class));
        }
    }

    @Override
    public UndergroundRootsFamily getFamily() {
        return (UndergroundRootsFamily)this.family;
    }

    @Override
    public boolean placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, int fertility) {
        boolean worldGenOnWater;
        BlockState dirtState = level.getBlockState(rootPos);
        Block dirt = dirtState.getBlock();
        boolean bl = worldGenOnWater = this.isWater(dirtState) && fertility == 0;
        if (!SoilHelper.isSoilRegistered(dirt) && !(dirt instanceof SoilBlock) || worldGenOnWater) {
            level.setBlock(rootPos, this.getFamily().getDefaultSoil().getSoilState(dirtState, fertility, this.doesRequireTileEntity(level, rootPos)), 3);
            BlockEntity tileEntity = level.getBlockEntity(rootPos);
            if (tileEntity instanceof SpeciesBlockEntity) {
                SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)tileEntity;
                speciesTE.setSpecies(this);
            }
            return true;
        }
        return super.placeRootyDirtBlock(level, rootPos, fertility);
    }

    private boolean replaceSoilBlock(BlockState soilState, Level level, BlockPos rootPos, int fertility) {
        SoilBlock soilBlock;
        Block block = soilState.getBlock();
        if (block instanceof SoilBlock && !(soilBlock = (SoilBlock)block).getSoilProperties().equals(this.getFamily().getDefaultSoil())) {
            BlockEntity TE = level.getBlockEntity(rootPos);
            BlockState rootCollarState = this.getFamily().getDefaultSoil().getSoilState(soilBlock.getPrimitiveSoilState(soilState), fertility, (Boolean)soilState.getValue((Property)SoilBlock.IS_VARIANT));
            this.getFamily().getDefaultSoil().getBlock().ifPresent(root -> root.updateRadius((LevelAccessor)level, rootCollarState, rootPos, 3, true));
            if (TE != null) {
                level.setBlockEntity(TE);
                if (TE instanceof SpeciesBlockEntity) {
                    SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)TE;
                    speciesTE.setSpecies(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean postGrow(Level level, BlockPos soilPos, BlockPos treePos, int fertility, boolean natural) {
        int radius = TreeHelper.getRadius((BlockGetter)level, treePos);
        BlockState soilState = level.getBlockState(soilPos);
        if (radius >= 8 || this.isWater(soilState) && radius >= this.updateSoilOnWaterRadius) {
            SoilBlock soilBlock = TreeHelper.getRooty(soilState);
            if (soilBlock == null) {
                return false;
            }
            BlockPos rootPos = soilPos.relative(soilBlock.getTrunkDirection((BlockGetter)level, soilPos).getOpposite());
            boolean hasRoots = TreeHelper.isBranch(level.getBlockState(rootPos));
            if (hasRoots) {
                this.replaceSoilBlock(soilState, level, soilPos, fertility);
            }
        }
        return super.postGrow(level, soilPos, treePos, fertility, natural);
    }

    @Override
    public boolean soilDestroyAction(Level level, @NotNull BlockPos rootPos, BlockState state, @NotNull Player player) {
        if (state.hasProperty((Property)SoilBlock.FERTILITY)) {
            return this.replaceSoilBlock(state, level, rootPos, (Integer)state.getValue((Property)SoilBlock.FERTILITY));
        }
        return false;
    }

    @Override
    public float rotChance(LevelAccessor level, BlockPos pos, RandomSource rand, int radius) {
        BlockState branchState = level.getBlockState(pos);
        if (branchState.getBlock() instanceof BasicRootsBlock) {
            if (radius == 0) {
                return 0.0f;
            }
            if (((Boolean)branchState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                return 0.0f;
            }
            return 0.2f + 1.0f / (8.0f + (float)radius * 4.0f);
        }
        return super.rotChance(level, pos, rand, radius);
    }

    @Override
    public boolean update(Level level, SoilBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        BlockPos rootCrownPos = rootPos.below();
        List<BlockPos> rootEnds = this.getEnds(level, rootCrownPos, TreeHelper.getTreePart(level.getBlockState(rootCrownPos)));
        this.handleRot((LevelAccessor)level, rootEnds, rootPos, rootCrownPos, fertility, false);
        return super.update(level, rootyDirt, rootPos, fertility, treeBase, treePos, random, natural);
    }

    @Override
    public boolean generate(DynamicTreeGenerationContext context) {
        JoCode code;
        int yOffset = context.random().nextIntBetweenInclusive(this.minWorldGenHeightOffset, this.maxWorldGenHeightOffset) - this.countWaterBlocksBelow(context.level(), (BlockPos)context.rootPos(), this.getAllowedWaterHeightForWorldgen());
        context.rootPos().move(Direction.UP, yOffset);
        if (super.generate(context) && !JoCodeRegistry.getCodes(this.getRegistryName(), true).isEmpty() && (code = JoCodeRegistry.getRandomCode(this.getRegistryName(), context.radius(), context.random(), true)) != null) {
            code.generate(context);
            return true;
        }
        return false;
    }

    public float getRootSignalEnergy() {
        return this.rootSignalEnergy;
    }

    public void setRootSignalEnergy(float rootSignalEnergy) {
        this.rootSignalEnergy = rootSignalEnergy;
    }

    public float getRootTapering() {
        return this.rootTapering;
    }

    public void setRootTapering(float rootTapering) {
        this.rootTapering = rootTapering;
    }

    @Override
    protected GrowSignal sendGrowthSignal(TreePart treeBase, Level level, BlockPos treePos, BlockPos rootPos, Direction defaultDir) {
        GrowSignal treeSignal = super.sendGrowthSignal(treeBase, level, treePos, rootPos, defaultDir);
        for (int i = 0; i < this.rootGrowthMultiplier; ++i) {
            BlockPos belowPos = rootPos.below();
            BlockState belowState = level.getBlockState(belowPos);
            if (TreeHelper.isBranch(belowState)) {
                GrowSignal rootGrowSignal = new GrowSignal(this, rootPos, this.getRootEnergy(level, rootPos), level.random, defaultDir.getOpposite());
                return TreeHelper.getTreePart(belowState).growSignal(level, belowPos, rootGrowSignal);
            }
            if (!this.isAcceptableSoil(belowState)) continue;
            this.getFamily().getRoots().ifPresent(branch -> branch.setRadius((LevelAccessor)level, belowPos, this.family.getPrimaryThickness(), null));
        }
        return treeSignal;
    }

    public float getRootEnergy(Level level, BlockPos rootPos) {
        return this.rootLogicKit.getEnergy(new PositionalSpeciesContext(level, rootPos, this));
    }

    public Species setRootsGrowthLogicKit(GrowthLogicKit logicKit) {
        this.rootLogicKit = (GrowthLogicKitConfiguration)logicKit.getDefaultConfiguration();
        return this;
    }

    public Species setRootsGrowthLogicKit(GrowthLogicKitConfiguration logicKit) {
        this.rootLogicKit = logicKit;
        return this;
    }

    public GrowthLogicKitConfiguration getRootsGrowthLogicKit() {
        return this.rootLogicKit;
    }
}

