/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class DynamicTreeGenerationContext {
    private final LevelContext levelContext;
    private final Species species;
    private final BlockPos originPos;
    private final BlockPos.MutableBlockPos rootPos;
    private final Holder<Biome> biome;
    private final Direction facing;
    private final int radius;
    private final boolean worldGen;
    private boolean secondChanceRegen;

    public DynamicTreeGenerationContext(LevelContext levelContext, Species species, BlockPos originPos, BlockPos.MutableBlockPos rootPos, Holder<Biome> biome, Direction facing, int radius, boolean worldGen) {
        this.levelContext = levelContext;
        this.species = species;
        this.originPos = originPos;
        this.rootPos = rootPos;
        this.biome = biome;
        this.facing = facing;
        this.radius = Mth.clamp((int)radius, (int)2, (int)8);
        this.worldGen = worldGen;
    }

    public LevelContext levelContext() {
        return this.levelContext;
    }

    public LevelAccessor level() {
        return this.levelContext.accessor();
    }

    public RandomSource random() {
        return this.level().getRandom();
    }

    public Species species() {
        return this.species;
    }

    public BlockPos originPos() {
        return this.originPos;
    }

    public BlockPos.MutableBlockPos rootPos() {
        return this.rootPos;
    }

    public Holder<Biome> biome() {
        return this.biome;
    }

    public Direction facing() {
        return this.facing;
    }

    public int radius() {
        return this.radius;
    }

    public boolean isWorldGen() {
        return this.worldGen;
    }

    public boolean secondChanceRegen() {
        return this.secondChanceRegen;
    }

    public void secondChance() {
        this.secondChanceRegen = true;
    }
}

