/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import java.util.Objects;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.registries.ForgeRegistries;

public class RootsStateGenerator
implements Generator<DTBlockStateProvider, Family> {
    public static final Generator.DependencyKey<BranchBlock> ROOT = new Generator.DependencyKey("root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_ROOT = new Generator.DependencyKey("primitive_root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_FILLED_ROOT = new Generator.DependencyKey("filled_primitive_root");
    public static final Generator.DependencyKey<Block> PRIMITIVE_COVERED_ROOT = new Generator.DependencyKey("covered_primitive_root");

    @Override
    public void generate(DTBlockStateProvider provider, Family input, Generator.Dependencies dependencies) {
        BranchBlock root = dependencies.get(ROOT);
        BranchLoaderBuilder builderExposed = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)root)).m_135815_())).customLoader(BranchLoaderBuilder::Roots);
        input.addRootTextures(builderExposed::texture, provider.block(ForgeRegistries.BLOCKS.getKey((Object)dependencies.get(PRIMITIVE_ROOT))));
        BranchLoaderBuilder builderFilled = (BranchLoaderBuilder)((BlockModelBuilder)provider.models().getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)root)).m_135815_() + "_filled")).customLoader(BranchLoaderBuilder::Roots);
        input.addRootTextures(builderFilled::texture, provider.block(ForgeRegistries.BLOCKS.getKey((Object)dependencies.get(PRIMITIVE_FILLED_ROOT))));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(root).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.EXPOSED)).modelForState().modelFile((ModelFile)((BlockModelBuilder)builderExposed.end()).renderType("cutout_mipped")).addModel()).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.FILLED)).modelForState().modelFile((ModelFile)builderFilled.end()).addModel()).partialState().with(BasicRootsBlock.LAYER, (Comparable)((Object)BasicRootsBlock.Layer.COVERED)).modelForState().modelFile((ModelFile)provider.models().getExistingFile(input.getModelPath("covered_roots_block").orElse(provider.blockTexture(dependencies.get(PRIMITIVE_COVERED_ROOT))))).addModel();
    }

    @Override
    public Generator.Dependencies gatherDependencies(Family input) {
        MangroveFamily mangroveInput = (MangroveFamily)input;
        return new Generator.Dependencies().append(ROOT, mangroveInput.getRoots()).append(PRIMITIVE_ROOT, mangroveInput.getPrimitiveRoots()).append(PRIMITIVE_FILLED_ROOT, mangroveInput.getPrimitiveFilledRoots()).append(PRIMITIVE_COVERED_ROOT, mangroveInput.getPrimitiveCoveredRoots());
    }
}

